/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.world.BalmMenuProvider;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ServerboundInventoryButtonPacket
implements class_8710 {
    public static final ServerboundInventoryButtonPacket INSTANCE = new ServerboundInventoryButtonPacket();
    public static final class_8710.class_9154<ServerboundInventoryButtonPacket> TYPE = new class_8710.class_9154(Waystones.id("inventory_button"));
    public static final class_9139<class_9129, ServerboundInventoryButtonPacket> STREAM_CODEC = class_9139.method_56431((Object)INSTANCE);

    private ServerboundInventoryButtonPacket() {
    }

    public static void handle(class_3222 player, ServerboundInventoryButtonPacket message) {
        Optional<Waystone> waystone;
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (!inventoryButtonMode.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.method_31549().field_7477) {
            PlayerWaystoneManager.resetCooldowns((class_1657)player);
        }
        if ((waystone = PlayerWaystoneManager.getInventoryButtonTarget((class_1657)player)).isPresent()) {
            WaystonesAPI.createDefaultTeleportContext((class_1297)player, waystone.get(), it -> it.addFlag(TeleportFlags.INVENTORY_BUTTON)).mapLeft(WaystonesAPI::tryTeleport);
        } else if (inventoryButtonMode.isReturnToAny()) {
            final ArrayList<Waystone> waystones = new ArrayList<Waystone>(PlayerWaystoneManager.getTargetsForInventoryButton(player));
            PlayerWaystoneManager.ensureSortingIndex((class_1657)player, waystones);
            BalmMenuProvider<List<Waystone>> containerProvider = new BalmMenuProvider<List<Waystone>>(){

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"container.waystones.waystone_selection");
                }

                public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 playerEntity) {
                    return new WaystoneSelectionMenu((class_3917<WaystoneSelectionMenu>)((class_3917)ModMenus.inventorySelection.comp_349()), null, windowId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
                }

                public List<Waystone> getScreenOpeningData(class_3222 serverPlayer) {
                    return waystones;
                }

                public class_9139<class_9129, List<Waystone>> getScreenStreamCodec() {
                    return WaystoneImpl.LIST_STREAM_CODEC;
                }
            };
            Balm.networking().openMenu((class_1657)player, (class_3908)containerProvider);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

