/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.batteryinfo;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import cpw.mods.util.Lazy;
import net.mgstudios.batteryinfo.util.BatteryStatusSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="batteryinfo")
public final class BatteryInfo {
    private boolean isHolding = false;
    private boolean shouldShowBattery = true;
    final Lazy<KeyMapping> keyMapping = Lazy.of((Object)new KeyMapping("key.category.batteryinfo.label", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 72, KeyMapping.Category.register((ResourceLocation)this.getResource("section"))));

    public BatteryInfo(FMLJavaModLoadingContext context) {
        LogUtils.getLogger().info("Battery Info (Forge) has been initialized!");
        RegisterKeyMappingsEvent.BUS.addListener(this::registerBindings);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderGui(CustomizeGuiOverlayEvent.Chat event) {
        int batteryLevel;
        if (System.getProperty("os.name").contains("Windows") && !Minecraft.getInstance().options.hideGui && !Minecraft.getInstance().getDebugOverlay().showDebugScreen() && this.shouldShowBattery && (batteryLevel = BatteryStatusSupplier.getBatteryPercentage()) != -1) {
            event.getGuiGraphics().blit(RenderPipelines.GUI_TEXTURED, this.getBatteryImage(batteryLevel), 5, Minecraft.getInstance().getWindow().getGuiScaledHeight() - 30, 0.0f, 0.0f, 50, 25, 50, 25);
        }
    }

    public void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)this.keyMapping.get());
    }

    @SubscribeEvent
    public void VisibilityToggleHandler(TickEvent.ClientTickEvent.Pre event) {
        if (((KeyMapping)this.keyMapping.get()).isDown()) {
            if (!this.isHolding && Minecraft.getInstance().player != null) {
                this.isHolding = true;
                this.shouldShowBattery = !this.shouldShowBattery;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)(Component.translatable((String)"toggle.feedback").getString() + this.shouldShowBattery)), true);
            }
        } else {
            this.isHolding = false;
        }
    }

    private ResourceLocation getBatteryImage(int batteryLevel) {
        if (batteryLevel > 80) {
            return this.getResource("textures/battery_5.png");
        }
        if (batteryLevel > 60) {
            return this.getResource("textures/battery_4.png");
        }
        if (batteryLevel > 40) {
            return this.getResource("textures/battery_3.png");
        }
        if (batteryLevel > 20) {
            return this.getResource("textures/battery_2.png");
        }
        return this.getResource("textures/battery_1.png");
    }

    private ResourceLocation getResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"batteryinfo", (String)path);
    }
}

