/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.batteryinfo.util;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public final class BatteryStatusSupplier {
    public static int getBatteryPercentage() {
        BatteryStatus status = new BatteryStatus();
        if (Kernel32.INSTANCE.GetSystemPowerStatus(status)) {
            return status.BatteryPercent;
        }
        return -1;
    }

    public static final class BatteryStatus
    extends Structure {
        public byte ACLineStatus;
        public byte BatteryFlag;
        public byte BatteryPercent;
        public byte Reserved1;
        public int BatteryLifeTime;
        public int BatteryFullLifeTime;

        protected List<String> getFieldOrder() {
            return Arrays.asList("ACLineStatus", "BatteryFlag", "BatteryPercent", "Reserved1", "BatteryLifeTime", "BatteryFullLifeTime");
        }
    }

    private static interface Kernel32
    extends Library {
        public static final Kernel32 INSTANCE = (Kernel32)Native.load((String)"kernel32", Kernel32.class);

        public boolean GetSystemPowerStatus(BatteryStatus var1);
    }
}

