/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.batteryinfo.client;

import com.mojang.logging.LogUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.mgstudios.batteryinfo.util.BatterySupplier;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_408;

public final class HudRenderer
implements ClientModInitializer {
    private boolean isHolding = false;
    private boolean batteryVisibility = true;

    boolean shouldShowBattery() {
        return !class_310.method_1551().field_1690.field_1842 && !class_310.method_1551().method_53526().method_53536() && !(class_310.method_1551().field_1755 instanceof class_408) && this.batteryVisibility;
    }

    public void onInitializeClient() {
        if (!System.getProperty("os.name").contains("Windows")) {
            LogUtils.getLogger().info("Since your system is not a Windows version, Battery Info Mod will not be enabled!");
            return;
        }
        LogUtils.getLogger().info("Battery Info has been initialized!");
        this.KeyHandler();
        HudElementRegistry.addFirst((class_2960)this.getResource("hud_renderer"), (guiGraphics, deltaTracker) -> {
            int batteryLevel;
            if (this.shouldShowBattery() && (batteryLevel = BatterySupplier.getBatteryPercent()) != -1) {
                guiGraphics.method_25290(class_10799.field_56883, this.getBatteryImage(batteryLevel), 5, class_310.method_1551().method_22683().method_4502() - 30, 0.0f, 0.0f, 50, 25, 50, 25);
            }
        });
    }

    private void KeyHandler() {
        class_304 key = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.category.batteryinfo.label", 72, class_304.class_11900.method_74698((class_2960)this.getResource("section"))));
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
            if (key.method_1434()) {
                if (!this.isHolding && minecraft.field_1724 != null) {
                    this.isHolding = true;
                    this.batteryVisibility = !this.batteryVisibility;
                    minecraft.field_1724.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"toggle.feedback").getString() + this.batteryVisibility)), true);
                }
            } else {
                this.isHolding = false;
            }
        });
    }

    private class_2960 getBatteryImage(int batteryLevel) {
        if (batteryLevel > 80) {
            return this.getResource("textures/battery_5.png");
        }
        if (batteryLevel > 60) {
            return this.getResource("textures/battery_4.png");
        }
        if (batteryLevel > 40) {
            return this.getResource("textures/battery_3.png");
        }
        if (batteryLevel > 20) {
            return this.getResource("textures/battery_2.png");
        }
        return this.getResource("textures/battery_1.png");
    }

    public class_2960 getResource(String path) {
        return class_2960.method_60655((String)"batteryinfo", (String)path);
    }
}

