/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.batteryinfo;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import net.mgstudios.batteryinfo.util.BatteryStatusSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="batteryinfo")
public class BatteryInfo {
    private boolean isHolding = false;
    private boolean shouldShowBattery = true;
    final KeyMapping keyMapping = new KeyMapping("key.category.batteryinfo.label", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 72, new KeyMapping.Category(this.getResource("section")));

    public BatteryInfo(IEventBus modEventBus, ModContainer modContainer) {
        LogUtils.getLogger().info("Battery Info (NeoForge) has been initialized!");
        modEventBus.addListener(this::registerBindings);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void registerBindings(RegisterKeyMappingsEvent event) {
        event.register(this.keyMapping);
    }

    @SubscribeEvent
    public void onRenderGui(CustomizeGuiOverlayEvent.Chat event) {
        int batteryLevel;
        if (System.getProperty("os.name").contains("Windows") && !Minecraft.getInstance().options.hideGui && !Minecraft.getInstance().getDebugOverlay().showDebugScreen() && !(Minecraft.getInstance().screen instanceof ChatScreen) && this.shouldShowBattery && (batteryLevel = BatteryStatusSupplier.getBatteryPercent()) != -1) {
            event.getGuiGraphics().blit(RenderPipelines.GUI_TEXTURED, this.getBatteryImage(batteryLevel), 5, Minecraft.getInstance().getWindow().getGuiScaledHeight() - 30, 0.0f, 0.0f, 50, 25, 50, 25);
        }
    }

    @SubscribeEvent
    public void VisibilityToggleHandler(ClientTickEvent.Post event) {
        if (this.keyMapping.isDown()) {
            if (!this.isHolding && Minecraft.getInstance().player != null) {
                this.isHolding = true;
                this.shouldShowBattery = !this.shouldShowBattery;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)(Component.translatable((String)"toggle.feedback").getString() + this.shouldShowBattery)), true);
            }
        } else {
            this.isHolding = false;
        }
    }

    private ResourceLocation getBatteryImage(int batteryLevel) {
        if (batteryLevel > 80) {
            return this.getResource("textures/battery_5.png");
        }
        if (batteryLevel > 60) {
            return this.getResource("textures/battery_4.png");
        }
        if (batteryLevel > 40) {
            return this.getResource("textures/battery_3.png");
        }
        if (batteryLevel > 20) {
            return this.getResource("textures/battery_2.png");
        }
        return this.getResource("textures/battery_1.png");
    }

    private ResourceLocation getResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"batteryinfo", (String)path);
    }
}

