/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.broadcasters;

import com.cobblemon.mod.common.util.WorldExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/broadcasters/SoundBroadcaster;", "", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/sounds/SoundEvent;", "sound", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;)V", "", "playShinySound", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "playShinySoundClient", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/sounds/SoundEvent;", "getSound", "()Lnet/minecraft/sounds/SoundEvent;", "cobblemon-spawn-notification"})
public final class SoundBroadcaster {
    @NotNull
    private final Level level;
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final SoundEvent sound;

    public SoundBroadcaster(@NotNull Level level, @NotNull BlockPos pos, @NotNull SoundEvent sound) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.level = level;
        this.pos = pos;
        this.sound = sound;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final SoundEvent getSound() {
        return this.sound;
    }

    public final void playShinySound() {
        Vec3 vec3 = this.pos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        WorldExtensionsKt.playSoundServer((Level)this.level, (Vec3)vec3, (SoundEvent)this.sound, (SoundSource)SoundSource.NEUTRAL, (float)10.0f, (float)1.0f);
    }

    public final void playShinySoundClient(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.playSound(this.sound, 10.0f, 1.0f);
    }
}

