/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.SpawnBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.IsReallyWildKt;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastUnnaturalSpawn;", "", "<init>", "()V", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/server/level/ServerLevel;", "world", "", "handle", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerLevel;)V", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nBroadcastUnnaturalSpawn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastUnnaturalSpawn.kt\nus/timinc/mc/cobblemon/spawnnotification/events/BroadcastUnnaturalSpawn\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1869#2,2:46\n*S KotlinDebug\n*F\n+ 1 BroadcastUnnaturalSpawn.kt\nus/timinc/mc/cobblemon/spawnnotification/events/BroadcastUnnaturalSpawn\n*L\n34#1:46,2\n*E\n"})
public final class BroadcastUnnaturalSpawn {
    @NotNull
    public static final BroadcastUnnaturalSpawn INSTANCE = new BroadcastUnnaturalSpawn();

    private BroadcastUnnaturalSpawn() {
    }

    public final void handle(@NotNull Entity entity, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        if (!IsReallyWildKt.isReallyWild(pokemon)) {
            return;
        }
        SchedulingFunctionsKt.afterOnServer((int)1, (Level)((Level)world), () -> BroadcastUnnaturalSpawn.handle$lambda$1(pokemon, entity, world));
    }

    private static final Unit handle$lambda$1(Pokemon $pokemon, Entity $entity, ServerLevel $world) {
        if ($pokemon.getPersistentData().contains("spawn_notification:spawn_broadcasted")) {
            return Unit.INSTANCE;
        }
        $pokemon.getPersistentData().putBoolean("spawn_notification:spawn_broadcasted", true);
        BlockPos pos = $entity.blockPosition();
        Intrinsics.checkNotNull((Object)pos);
        ResourceLocation resourceLocation = ((ResourceKey)$world.getBiomeManager().getBiome(pos).unwrapKey().get()).location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        ResourceLocation resourceLocation2 = $world.dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        List<Component> messages = new SpawnBroadcaster($pokemon, pos, resourceLocation, resourceLocation2, null).getBroadcast();
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component message = (Component)element$iv;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
                continue;
            }
            if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                ResourceKey resourceKey = $world.dimension();
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers((ResourceKey<Level>)resourceKey, pos), message);
                continue;
            }
            Broadcast.INSTANCE.broadcastMessage($world, message);
        }
        return Unit.INSTANCE;
    }
}

