/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.broadcasters;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.config.SpawnNotificationConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\u0019\u0010\n\u001a\u0004\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0016\u0010&\u001a\u0004\u0018\u00010#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010(\u001a\u0004\u0018\u00010#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0014\u0010*\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001f\u00a8\u0006+"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/broadcasters/CaptureBroadcaster;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/class_2338;", "coords", "Lnet/minecraft/class_2960;", "biome", "dimension", "Lnet/minecraft/class_3222;", "player", "<init>", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/class_2338;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_2561;", "getBroadcast", "()Lnet/minecraft/class_2561;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lnet/minecraft/class_2338;", "getCoords", "()Lnet/minecraft/class_2338;", "Lnet/minecraft/class_2960;", "getBiome", "()Lnet/minecraft/class_2960;", "getDimension", "Lnet/minecraft/class_3222;", "getPlayer", "()Lnet/minecraft/class_3222;", "", "getShiny", "()Z", "shiny", "getBlacklisted", "blacklisted", "", "getLabel", "()Ljava/lang/String;", "label", "getBucket", "bucket", "getShouldBroadcast", "shouldBroadcast", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nCaptureBroadcaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureBroadcaster.kt\nus/timinc/mc/cobblemon/spawnnotification/broadcasters/CaptureBroadcaster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1755#2,3:81\n295#2,2:84\n295#2,2:86\n2632#2,3:88\n*S KotlinDebug\n*F\n+ 1 CaptureBroadcaster.kt\nus/timinc/mc/cobblemon/spawnnotification/broadcasters/CaptureBroadcaster\n*L\n22#1:81,3\n28#1:84,2\n30#1:86,2\n36#1:88,3\n*E\n"})
public final class CaptureBroadcaster {
    @NotNull
    private final Pokemon pokemon;
    @NotNull
    private final class_2338 coords;
    @NotNull
    private final class_2960 biome;
    @NotNull
    private final class_2960 dimension;
    @Nullable
    private final class_3222 player;

    public CaptureBroadcaster(@NotNull Pokemon pokemon, @NotNull class_2338 coords, @NotNull class_2960 biome, @NotNull class_2960 dimension, @Nullable class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.pokemon = pokemon;
        this.coords = coords;
        this.biome = biome;
        this.dimension = dimension;
        this.player = player;
    }

    @NotNull
    public final Pokemon getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final class_2338 getCoords() {
        return this.coords;
    }

    @NotNull
    public final class_2960 getBiome() {
        return this.biome;
    }

    @NotNull
    public final class_2960 getDimension() {
        return this.dimension;
    }

    @Nullable
    public final class_3222 getPlayer() {
        return this.player;
    }

    private final boolean getShiny() {
        return this.pokemon.getShiny();
    }

    private final boolean getBlacklisted() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = SpawnNotification.INSTANCE.getConfig().getBlacklistForBroadcast();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null).matches(this.pokemon)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getLabel() {
        String string;
        if (this.getBlacklisted()) {
            string = null;
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this.pokemon.getForm().getLabels();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!SpawnNotification.INSTANCE.getConfig().getLabelsForBroadcast().contains(it)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            string = v1;
        }
        return string;
    }

    private final String getBucket() {
        String string;
        if (this.getBlacklisted() || !this.pokemon.getPersistentData().method_10545("spawn_notification:bucket")) {
            string = null;
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = SpawnNotification.INSTANCE.getConfig().getBucketsForBroadcast();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)this.pokemon.getPersistentData().method_10558("spawn_notification:bucket"))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            string = v1;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldBroadcast() {
        String it;
        if (!(this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny() || this.getLabel() != null)) {
            if (this.getBucket() == null) return false;
        }
        Iterable $this$none$iv = SpawnNotification.INSTANCE.getConfig().getBlacklistForBroadcastEvenIfShiny();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null).matches(this.pokemon));
        return false;
    }

    @Nullable
    public final class_2561 getBroadcast() {
        String string;
        String string2;
        Object[] objectArray;
        if (!this.getShouldBroadcast()) {
            return null;
        }
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[8];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string2 = "";
        }
        objectArray2[2] = string2;
        objectArray2[3] = this.pokemon.getSpecies().getTranslatedName();
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastBiome()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getRawComponent("biome." + this.biome.method_42094(), new Object[0])};
            v4 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.biome", objectArray);
        } else {
            v4 = objectArray2[4] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastCoords()) {
            objectArray = new Object[]{this.coords.method_10263(), this.coords.method_10264(), this.coords.method_10260()};
            v5 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.coords", objectArray);
        } else {
            v5 = objectArray2[5] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getRawComponent("dimension." + this.dimension.method_42094(), new Object[0])};
            v6 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.dimension", objectArray);
        } else {
            v6 = objectArray2[6] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getAnnounceDespawnPlayer() && this.player != null) {
            objectArray = new Object[]{this.player.method_5477()};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.player.despawn", objectArray);
        } else {
            string = "";
        }
        objectArray2[7] = string;
        return spawnNotificationConfig.getComponent("notification.capture", objectArray2);
    }
}

