/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.destination;

import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.context.BroadcastContext;
import us.timinc.mc.cobblemon.spawnnotification.data.AbstractBroadcastData;
import us.timinc.mc.cobblemon.spawnnotification.destination.Destination;
import us.timinc.mc.cobblemon.spawnnotification.destination.Sound;
import us.timinc.mc.cobblemon.timcore.Debugger;
import us.timinc.mc.cobblemon.timcore.PokemonMatcher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/destination/Sound;", "Lus/timinc/mc/cobblemon/spawnnotification/destination/Destination;", "Lus/timinc/mc/cobblemon/spawnnotification/destination/Sound$BroadcastData;", "<init>", "()V", "broadcastData", "Lus/timinc/mc/cobblemon/spawnnotification/context/BroadcastContext;", "broadcastContext", "", "broadcast", "(Lus/timinc/mc/cobblemon/spawnnotification/destination/Sound$BroadcastData;Lus/timinc/mc/cobblemon/spawnnotification/context/BroadcastContext;)V", "Lcom/mojang/serialization/Codec;", "codec", "Lcom/mojang/serialization/Codec;", "getCodec", "()Lcom/mojang/serialization/Codec;", "BroadcastData", "common"})
public final class Sound
extends Destination<BroadcastData> {
    @NotNull
    public static final Sound INSTANCE = new Sound();
    @NotNull
    private static final Codec<BroadcastData> codec;

    private Sound() {
    }

    @Override
    public void broadcast(@NotNull BroadcastData broadcastData, @NotNull BroadcastContext broadcastContext) {
        Intrinsics.checkNotNullParameter((Object)broadcastData, (String)"broadcastData");
        Intrinsics.checkNotNullParameter((Object)broadcastContext, (String)"broadcastContext");
        SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)broadcastData.getSound());
        Level level = (Level)broadcastContext.getWorld();
        Vec3 vec3 = broadcastContext.getPosition();
        Intrinsics.checkNotNull((Object)soundEvent);
        WorldExtensionsKt.playSoundServer((Level)level, (Vec3)vec3, (SoundEvent)soundEvent, (SoundSource)SoundSource.valueOf((String)broadcastData.getSource()), (float)broadcastData.getVolume(), (float)broadcastData.getPitch());
        Debugger debugger = SpawnNotification.INSTANCE.getDebugger();
        String string = broadcastContext.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Debugger.Case debugger2 = debugger.getCaseDebugger(string);
        Debugger.debug$default((Debugger)((Debugger)debugger2), (String)("Played sound " + soundEvent), (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public Codec<BroadcastData> getCodec() {
        return codec;
    }

    private static final App codec$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)PokemonMatcher.Companion.getSTRING_CODEC().listOf().fieldOf("matcher").forGetter(arg_0 -> Sound.codec$lambda$0$0((KProperty1)codec.1.1.INSTANCE, arg_0)), (App)PokemonMatcher.Companion.getSTRING_CODEC().listOf().optionalFieldOf("antiMatcher").forGetter(Sound::codec$lambda$0$1), (App)ResourceLocation.CODEC.fieldOf("destination").forGetter(arg_0 -> Sound.codec$lambda$0$2((KProperty1)codec.1.3.INSTANCE, arg_0)), (App)ResourceLocation.CODEC.listOf().fieldOf("triggers").forGetter(arg_0 -> Sound.codec$lambda$0$3((KProperty1)codec.1.4.INSTANCE, arg_0)), (App)ResourceLocation.CODEC.fieldOf("sound").forGetter(arg_0 -> Sound.codec$lambda$0$4((KProperty1)codec.1.5.INSTANCE, arg_0)), (App)Codec.FLOAT.optionalFieldOf("volume").forGetter(Sound::codec$lambda$0$5), (App)Codec.FLOAT.optionalFieldOf("pitch").forGetter(Sound::codec$lambda$0$6), (App)Codec.STRING.optionalFieldOf("source").forGetter(Sound::codec$lambda$0$7)).apply((Applicative)instance, Sound::codec$lambda$0$8);
    }

    private static final List codec$lambda$0$0(KProperty1 $tmp0, BroadcastData p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional codec$lambda$0$1(BroadcastData it) {
        return Optional.ofNullable(it.getAntiMatcher());
    }

    private static final ResourceLocation codec$lambda$0$2(KProperty1 $tmp0, BroadcastData p0) {
        return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List codec$lambda$0$3(KProperty1 $tmp0, BroadcastData p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ResourceLocation codec$lambda$0$4(KProperty1 $tmp0, BroadcastData p0) {
        return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional codec$lambda$0$5(BroadcastData it) {
        return Optional.ofNullable(Float.valueOf(it.getVolume()));
    }

    private static final Optional codec$lambda$0$6(BroadcastData it) {
        return Optional.ofNullable(Float.valueOf(it.getPitch()));
    }

    private static final Optional codec$lambda$0$7(BroadcastData it) {
        return Optional.ofNullable(it.getSource());
    }

    private static final BroadcastData codec$lambda$0$8(List matcher, Optional antiMatcher, ResourceLocation destination, List triggers, ResourceLocation sound, Optional volume, Optional pitch, Optional source) {
        Intrinsics.checkNotNull((Object)matcher);
        List list = antiMatcher.orElse(null);
        Intrinsics.checkNotNull((Object)destination);
        Intrinsics.checkNotNull((Object)triggers);
        Intrinsics.checkNotNull((Object)sound);
        Float f = volume.orElse(Float.valueOf(1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"orElse(...)");
        float f2 = ((Number)f).floatValue();
        Float f3 = pitch.orElse(Float.valueOf(1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"orElse(...)");
        float f4 = ((Number)f3).floatValue();
        String string = source.orElse("neutral");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElse(...)");
        return new BroadcastData(matcher, list, destination, triggers, sound, f2, f4, string);
    }

    static {
        Codec codec2 = RecordCodecBuilder.create(Sound::codec$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        codec = codec2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B[\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u001d\u0010\u0018R\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001a\u001a\u0004\b\u001e\u0010\u001cR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001f\u001a\u0004\b\"\u0010!R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/destination/Sound$BroadcastData;", "Lus/timinc/mc/cobblemon/spawnnotification/data/AbstractBroadcastData;", "", "Lus/timinc/mc/cobblemon/timcore/PokemonMatcher;", "matcher", "antiMatcher", "Lnet/minecraft/resources/ResourceLocation;", "destination", "triggers", "sound", "", "volume", "pitch", "", "source", "<init>", "(Ljava/util/List;Ljava/util/List;Lnet/minecraft/resources/ResourceLocation;Ljava/util/List;Lnet/minecraft/resources/ResourceLocation;FFLjava/lang/String;)V", "Lus/timinc/mc/cobblemon/spawnnotification/context/BroadcastContext;", "broadcastContext", "", "broadcast", "(Lus/timinc/mc/cobblemon/spawnnotification/context/BroadcastContext;)V", "Ljava/util/List;", "getMatcher", "()Ljava/util/List;", "getAntiMatcher", "Lnet/minecraft/resources/ResourceLocation;", "getDestination", "()Lnet/minecraft/resources/ResourceLocation;", "getTriggers", "getSound", "F", "getVolume", "()F", "getPitch", "Ljava/lang/String;", "getSource", "()Ljava/lang/String;", "common"})
    public static final class BroadcastData
    extends AbstractBroadcastData<BroadcastData> {
        @NotNull
        private final List<PokemonMatcher> matcher;
        @Nullable
        private final List<PokemonMatcher> antiMatcher;
        @NotNull
        private final ResourceLocation destination;
        @NotNull
        private final List<ResourceLocation> triggers;
        @NotNull
        private final ResourceLocation sound;
        private final float volume;
        private final float pitch;
        @NotNull
        private final String source;

        public BroadcastData(@NotNull List<PokemonMatcher> matcher, @Nullable List<PokemonMatcher> antiMatcher, @NotNull ResourceLocation destination, @NotNull List<ResourceLocation> triggers, @NotNull ResourceLocation sound, float volume, float pitch, @NotNull String source) {
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(matcher, antiMatcher, destination, triggers);
            this.matcher = matcher;
            this.antiMatcher = antiMatcher;
            this.destination = destination;
            this.triggers = triggers;
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
            this.source = source;
        }

        @Override
        @NotNull
        public List<PokemonMatcher> getMatcher() {
            return this.matcher;
        }

        @Override
        @Nullable
        public List<PokemonMatcher> getAntiMatcher() {
            return this.antiMatcher;
        }

        @Override
        @NotNull
        public ResourceLocation getDestination() {
            return this.destination;
        }

        @Override
        @NotNull
        public List<ResourceLocation> getTriggers() {
            return this.triggers;
        }

        @NotNull
        public final ResourceLocation getSound() {
            return this.sound;
        }

        public final float getVolume() {
            return this.volume;
        }

        public final float getPitch() {
            return this.pitch;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @Override
        public void broadcast(@NotNull BroadcastContext broadcastContext) {
            Intrinsics.checkNotNullParameter((Object)broadcastContext, (String)"broadcastContext");
            INSTANCE.broadcast(this, broadcastContext);
        }
    }
}

