/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.registry;

import com.cobblemon.mod.common.api.reactive.EventObservable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R \u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u00138\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry;", "T", "", "Lnet/minecraft/resources/ResourceLocation;", "name", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "key", "value", "register", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Object;)Ljava/lang/Object;", "get", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;", "Lnet/minecraft/resources/ResourceLocation;", "getName", "()Lnet/minecraft/resources/ResourceLocation;", "", "registered", "Ljava/util/Map;", "Lcom/cobblemon/mod/common/api/reactive/EventObservable;", "Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry$RegistryEntryLoadedEvent;", "entryRegistered", "Lcom/cobblemon/mod/common/api/reactive/EventObservable;", "RegistryEntryLoadedEvent", "common"})
@SourceDebugExtension(value={"SMAP\nLazyRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyRegistry.kt\nus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,26:1\n14#2,5:27\n19#2:35\n13805#3:32\n13806#3:34\n14#4:33\n*S KotlinDebug\n*F\n+ 1 LazyRegistry.kt\nus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry\n*L\n21#1:27,5\n21#1:35\n21#1:32\n21#1:34\n21#1:33\n*E\n"})
public final class LazyRegistry<T> {
    @NotNull
    private final ResourceLocation name;
    @NotNull
    private final Map<ResourceLocation, T> registered;
    @JvmField
    @NotNull
    public final EventObservable<RegistryEntryLoadedEvent<T>> entryRegistered;

    public LazyRegistry(@NotNull ResourceLocation name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.registered = new LinkedHashMap();
        this.entryRegistered = new EventObservable();
    }

    @NotNull
    public final ResourceLocation getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public final T register(@NotNull ResourceLocation key, T value) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.registered.containsKey(key)) {
            throw new Exception("Key " + key + " already present in registry " + this.name + ".");
        }
        this.registered.put(key, value);
        EventObservable<RegistryEntryLoadedEvent<T>> eventObservable = this.entryRegistered;
        RegistryEntryLoadedEvent[] registryEntryLoadedEventArray = new RegistryEntryLoadedEvent[]{new RegistryEntryLoadedEvent<T>(value, key, this)};
        RegistryEntryLoadedEvent[] events$iv = registryEntryLoadedEventArray;
        boolean $i$f$post = false;
        $this$iv.emit((Object[])Arrays.copyOf(events$iv, events$iv.length));
        RegistryEntryLoadedEvent[] $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            RegistryEntryLoadedEvent element$iv$iv;
            RegistryEntryLoadedEvent registryEntryLoadedEvent = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            RegistryEntryLoadedEvent it = registryEntryLoadedEvent;
        }
        return value;
    }

    @Nullable
    public final T get(@NotNull ResourceLocation key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.registered.get(key);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ:\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\u000f\u00a8\u0006\""}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry$RegistryEntryLoadedEvent;", "T", "", "entry", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry;", "registry", "<init>", "(Ljava/lang/Object;Lnet/minecraft/resources/ResourceLocation;Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry;)V", "component1", "()Ljava/lang/Object;", "component2", "()Lnet/minecraft/resources/ResourceLocation;", "component3", "()Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry;", "copy", "(Ljava/lang/Object;Lnet/minecraft/resources/ResourceLocation;Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry;)Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry$RegistryEntryLoadedEvent;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "getEntry", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "Lus/timinc/mc/cobblemon/spawnnotification/registry/LazyRegistry;", "getRegistry", "common"})
    public static final class RegistryEntryLoadedEvent<T> {
        private final T entry;
        @NotNull
        private final ResourceLocation key;
        @NotNull
        private final LazyRegistry<T> registry;

        public RegistryEntryLoadedEvent(T entry, @NotNull ResourceLocation key, @NotNull LazyRegistry<T> registry) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            this.entry = entry;
            this.key = key;
            this.registry = registry;
        }

        public final T getEntry() {
            return this.entry;
        }

        @NotNull
        public final ResourceLocation getKey() {
            return this.key;
        }

        @NotNull
        public final LazyRegistry<T> getRegistry() {
            return this.registry;
        }

        public final T component1() {
            return this.entry;
        }

        @NotNull
        public final ResourceLocation component2() {
            return this.key;
        }

        @NotNull
        public final LazyRegistry<T> component3() {
            return this.registry;
        }

        @NotNull
        public final RegistryEntryLoadedEvent<T> copy(T entry, @NotNull ResourceLocation key, @NotNull LazyRegistry<T> registry) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            return new RegistryEntryLoadedEvent<T>(entry, key, registry);
        }

        public static /* synthetic */ RegistryEntryLoadedEvent copy$default(RegistryEntryLoadedEvent registryEntryLoadedEvent, Object object, ResourceLocation resourceLocation, LazyRegistry lazyRegistry, int n, Object object2) {
            if ((n & 1) != 0) {
                object = registryEntryLoadedEvent.entry;
            }
            if ((n & 2) != 0) {
                resourceLocation = registryEntryLoadedEvent.key;
            }
            if ((n & 4) != 0) {
                lazyRegistry = registryEntryLoadedEvent.registry;
            }
            return registryEntryLoadedEvent.copy(object, resourceLocation, lazyRegistry);
        }

        @NotNull
        public String toString() {
            return "RegistryEntryLoadedEvent(entry=" + this.entry + ", key=" + this.key + ", registry=" + this.registry + ")";
        }

        public int hashCode() {
            int result = this.entry == null ? 0 : this.entry.hashCode();
            result = result * 31 + this.key.hashCode();
            result = result * 31 + this.registry.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegistryEntryLoadedEvent)) {
                return false;
            }
            RegistryEntryLoadedEvent registryEntryLoadedEvent = (RegistryEntryLoadedEvent)other;
            if (!Intrinsics.areEqual(this.entry, registryEntryLoadedEvent.entry)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)registryEntryLoadedEvent.key)) {
                return false;
            }
            return Intrinsics.areEqual(this.registry, registryEntryLoadedEvent.registry);
        }
    }
}

