/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import com.mojang.blaze3d.platform.FramerateLimitTracker;
import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.IdleCondition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FramerateLimitTracker.class})
public class FramerateLimitTrackerMixin {
    @Shadow
    @Final
    private Options options;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private int framerateLimit;

    @Inject(method={"getFramerateLimit()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFramerateLimit(CallbackInfoReturnable<Integer> callbackInfo) {
        PowerState state = DynamicFPSMod.powerState();
        if (state != PowerState.FOCUSED) {
            callbackInfo.setReturnValue((Object)Math.max(this.getFramerateTarget(), 15));
        } else {
            IdleCondition condition = DynamicFPSConfig.INSTANCE.idle().condition();
            if (condition != IdleCondition.VANILLA) {
                if (this.isInLevel()) {
                    callbackInfo.setReturnValue((Object)this.framerateLimit);
                } else if (DynamicFPSConfig.INSTANCE.uncapMenuFrameRate()) {
                    callbackInfo.setReturnValue((Object)this.getMenuFramerateLimit());
                } else {
                    callbackInfo.setReturnValue((Object)60);
                }
            }
        }
    }

    @Inject(method={"getFramerateLimit()I"}, at={@At(value="CONSTANT", args={"intValue=60"})}, cancellable=true)
    private void getMenuFramerateLimit(CallbackInfoReturnable<Integer> callbackInfo) {
        int limit = this.getFramerateTarget();
        if (DynamicFPSMod.powerState() != PowerState.FOCUSED) {
            if (limit < 60) {
                callbackInfo.setReturnValue((Object)limit);
            }
        } else if (DynamicFPSConfig.INSTANCE.uncapMenuFrameRate()) {
            callbackInfo.setReturnValue((Object)this.getMenuFramerateLimit());
        }
    }

    @Unique
    private int getFramerateTarget() {
        return DynamicFPSMod.targetFrameRate();
    }

    @Unique
    private int getMenuFramerateLimit() {
        if (((Boolean)this.options.enableVsync().get()).booleanValue()) {
            return 260;
        }
        return Math.min(this.framerateLimit, 250);
    }

    @Unique
    private boolean isInLevel() {
        return this.minecraft.level != null || this.minecraft.screen == null && this.minecraft.getOverlay() == null;
    }
}

