/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.battery;

import dynamic_fps.impl.util.ResourceLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseToast
implements Toast {
    private long firstRender;
    private Toast.Visibility visibility;
    protected Component title;
    protected Component description;
    @Nullable
    protected ResourceLocation icon;
    private static final ResourceLocation MOD_ICON = ResourceLocations.of("dynamic_fps", "textures/battery/toast/background_icon.png");
    private static final ResourceLocation BACKGROUND_IMAGE = ResourceLocations.of("dynamic_fps", "textures/battery/toast/background.png");

    protected BaseToast(Component title, Component description, @Nullable ResourceLocation icon) {
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.visibility = Toast.Visibility.SHOW;
    }

    @NotNull
    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void update(ToastManager toastManager, long currentTime) {
        if (this.firstRender == 0L) {
            return;
        }
        if ((double)(currentTime - this.firstRender) >= 5000.0 * toastManager.getNotificationDisplayTimeMultiplier()) {
            this.visibility = Toast.Visibility.HIDE;
        }
    }

    public void render(GuiGraphics graphics, Font font, long currentTime) {
        if (this.firstRender == 0L) {
            this.onFirstRender();
            this.firstRender = currentTime;
        }
        graphics.blit(RenderType::guiTextured, BACKGROUND_IMAGE, 0, 0, 0.0f, 0.0f, this.width(), this.height(), this.width(), this.height());
        int x = 8;
        if (this.icon != null) {
            x += 22;
            graphics.blit(RenderType::guiTextured, MOD_ICON, 2, 2, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.blit(RenderType::guiTextured, this.icon, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        graphics.drawString(Minecraft.getInstance().font, this.title, x, 7, 6238997, false);
        graphics.drawString(Minecraft.getInstance().font, this.description, x, 18, -16777216, false);
    }

    public void onFirstRender() {
    }
}

