/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import liedge.limacore.event.DamageAttributeModifiersEvent;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaLootUtil;
import liedge.ltxindustries.LTXICapabilities;
import liedge.ltxindustries.entity.BubbleShieldUser;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.entity.damage.DropsRedirect;
import liedge.ltxindustries.entity.damage.UpgradableDamageSource;
import liedge.ltxindustries.entity.damage.UpgradableEquipmentDamageSource;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.EquipmentDamageModifiers;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import liedge.ltxindustries.lib.upgrades.effect.DirectDropsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIMobEffects;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="ltxi")
public final class LTXIEventHandler {
    private LTXIEventHandler() {
    }

    @SubscribeEvent
    public static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)EquipmentDamageModifiers.getInstance());
    }

    @SubscribeEvent
    public static void onVanillaGameEvent(VanillaGameEvent event) {
        Entity entity = event.getCause();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean cancelEvent = false;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                EquipmentUpgrades upgrades = UpgradableEquipmentItem.getEquipmentUpgradesFromStack(player.getItemBySlot(slot));
                if (!upgrades.anyMatch((DataComponentType)LTXIUpgradeEffectComponents.PREVENT_VIBRATION.get(), (effect, ignored) -> effect.apply(slot, (Holder<GameEvent>)event.getVanillaEvent()))) continue;
                cancelEvent = true;
                break;
            }
            event.setCanceled(cancelEvent);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        Level level = event.getEntity().level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = event.getTo().getItem();
            if (level instanceof UpgradableEquipmentItem) {
                UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)level;
                ItemStack stack = event.getTo();
                EquipmentUpgrades upgrades = equipmentItem.getUpgrades(stack);
                Integer lastHash = (Integer)stack.get(LTXIDataComponents.LAST_EQUIPMENT_HASH);
                if (lastHash == null || lastHash.intValue() != upgrades.hashCode()) {
                    equipmentItem.onUpgradeRefresh(LimaLootUtil.emptyLootContext((ServerLevel)level2), stack, upgrades);
                    stack.set(LTXIDataComponents.LAST_EQUIPMENT_HASH, (Object)upgrades.hashCode());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.getMainHandItem();
        WeaponItem weaponItem = (WeaponItem)LimaCoreUtil.castOrNull(WeaponItem.class, (Object)heldItem.getItem());
        ((AbstractWeaponControls)player.getData(LTXIAttachmentTypes.WEAPON_CONTROLS)).tickInput(player, heldItem, weaponItem);
    }

    @SubscribeEvent
    public static void onPostEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getExistingData(LTXIAttachmentTypes.BUBBLE_SHIELD).ifPresent(shield -> shield.tickShield(livingEntity));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (entity instanceof Player) {
            UpgradableEquipmentItem equipmentItem;
            EquipmentUpgrades upgrades;
            DropsRedirect redirect;
            Player player = (Player)entity;
            entity = event.getTool().getItem();
            if (entity instanceof UpgradableEquipmentItem && (redirect = DropsRedirect.forPlayer(player, upgrades = (equipmentItem = (UpgradableEquipmentItem)entity).getUpgrades(event.getTool()), DirectDropsUpgradeEffect.Type.BLOCK_DROPS)) != null) {
                redirect.captureAndRelocateDrops(event.getDrops());
                int xp = event.getDroppedExperience();
                event.setDroppedExperience(0);
                player.giveExperiencePoints(xp);
            }
        }
    }

    @SubscribeEvent
    public static void checkEffectApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity;
        Entity entity = event.getEffectSource();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(LTXIMobEffects.NEURO_SUPPRESSED)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        ItemStack stack;
        Item item;
        Player player = event.getEntity();
        if (!player.level().isClientSide() && (item = (stack = player.getMainHandItem()).getItem()) instanceof UpgradableEquipmentItem) {
            UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
            TriState result = LTXIEntityUtil.checkUpgradeTargetValidity((Entity)player, event.getTarget(), equipmentItem.getUpgrades(stack));
            if (result.isFalse()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        DamageSource damageSource = event.getSource();
        DropsRedirect dropsRedirect = null;
        if (damageSource instanceof UpgradableDamageSource) {
            UpgradableDamageSource upgradableSource = (UpgradableDamageSource)damageSource;
            dropsRedirect = upgradableSource.createDropsRedirect();
        } else {
            Player player;
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof Player && (entity = (player = (Player)entity).getWeaponItem().getItem()) instanceof UpgradableEquipmentItem) {
                UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)entity;
                if (damageSource.is(DamageTypeTags.IS_PLAYER_ATTACK)) {
                    EquipmentUpgrades upgrades = equipmentItem.getUpgrades(player.getWeaponItem());
                    dropsRedirect = DropsRedirect.forPlayer(player, upgrades, DirectDropsUpgradeEffect.Type.ENTITY_DROPS);
                }
            }
        }
        if (dropsRedirect != null) {
            dropsRedirect.captureAndRelocateDrops(event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingIncomingDamageHighest(LivingIncomingDamageEvent event) {
        LivingEntity attacker;
        DamageSource source = event.getSource();
        UpgradesContainerBase<?, ?> upgrades = LTXIEventHandler.getUpgradesFromDamage(source);
        if (upgrades == null) {
            return;
        }
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity && !(attacker = (LivingEntity)entity).level().isClientSide() && source.is(DamageTypeTags.IS_PLAYER_ATTACK)) {
            upgrades.applyDamageContextEffects((Supplier<DataComponentType<List<TargetedConditionalEffect<EntityUpgradeEffect>>>>)LTXIUpgradeEffectComponents.EQUIPMENT_PRE_ATTACK, (ServerLevel)attacker.level(), EnchantmentTarget.ATTACKER, (Entity)event.getEntity(), attacker, source);
        }
        upgrades.forEachEffect(LTXIUpgradeEffectComponents.DAMAGE_REDUCTION_MODIFIER, (effect, rank) -> {
            float modifier = Mth.clamp((float)effect.amount().calculate(rank), (float)-1.0f, (float)0.0f);
            event.addReductionModifier(effect.reductionType().getReduction(), (container, reduction) -> reduction + reduction * modifier);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingIncomingDamageLowest(LivingIncomingDamageEvent event) {
        BubbleShieldUser shieldUser;
        LivingEntity hurtEntity = event.getEntity();
        if (!hurtEntity.level().isClientSide() && (shieldUser = (BubbleShieldUser)hurtEntity.getCapability(LTXICapabilities.ENTITY_BUBBLE_SHIELD)) != null && shieldUser.blockDamage(hurtEntity, hurtEntity.level(), event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDamageAttributeModifiers(DamageAttributeModifiersEvent event) {
        UpgradesContainerBase<?, ?> upgrades = LTXIEventHandler.getUpgradesFromDamage(event.getDamageSource());
        if (upgrades != null) {
            upgrades.forEachEffect(LTXIUpgradeEffectComponents.DAMAGE_ATTRIBUTE_MODIFIERS, (effect, rank) -> event.addAttributeModifier(effect.attribute(), effect.createModifier(rank)));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity attacker;
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity && !(attacker = (LivingEntity)entity).level().isClientSide()) {
            Item item;
            EquipmentUpgrades upgrades = null;
            if (damageSource instanceof UpgradableDamageSource) {
                UpgradableDamageSource upgradableSource = (UpgradableDamageSource)damageSource;
                upgrades = upgradableSource.getUpgrades();
            } else if (damageSource.getDirectEntity() == attacker && (item = attacker.getWeaponItem().getItem()) instanceof UpgradableEquipmentItem) {
                UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
                if (damageSource.is(DamageTypeTags.IS_PLAYER_ATTACK)) {
                    upgrades = equipmentItem.getUpgrades(attacker.getWeaponItem());
                }
            }
            if (upgrades != null) {
                upgrades.applyDamageContextEffects((Supplier<? extends DataComponentType<List<TargetedConditionalEffect<EntityUpgradeEffect>>>>)LTXIUpgradeEffectComponents.EQUIPMENT_KILL, (ServerLevel)attacker.level(), EnchantmentTarget.ATTACKER, (Entity)event.getEntity(), attacker, damageSource);
            }
        }
    }

    @Nullable
    private static UpgradesContainerBase<?, ?> getUpgradesFromDamage(DamageSource source) {
        Item item;
        if (source instanceof UpgradableEquipmentDamageSource) {
            UpgradableEquipmentDamageSource upgradableSource = (UpgradableEquipmentDamageSource)source;
            return upgradableSource.getUpgrades();
        }
        ItemStack stack = source.getWeaponItem();
        if (stack != null && (item = stack.getItem()) instanceof UpgradableEquipmentItem) {
            UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
            return equipmentItem.getUpgrades(stack);
        }
        return null;
    }
}

