/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries;

import com.mojang.logging.LogUtils;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaNetworkUtil;
import liedge.ltxindustries.LTXICapabilities;
import liedge.ltxindustries.entity.BubbleShieldUser;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrade;
import liedge.ltxindustries.network.packet.ClientboundFocusTargetPacket;
import liedge.ltxindustries.network.packet.ClientboundWeaponControlsPacket;
import liedge.ltxindustries.network.packet.ServerboundItemModeSwitchPacket;
import liedge.ltxindustries.network.packet.ServerboundWeaponControlsPacket;
import liedge.ltxindustries.recipe.RecipeMode;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXICreativeTabs;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.registry.game.LTXIEntityUpgradeEffects;
import liedge.ltxindustries.registry.game.LTXIFluids;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXILootRegistries;
import liedge.ltxindustries.registry.game.LTXIMenus;
import liedge.ltxindustries.registry.game.LTXIMobEffects;
import liedge.ltxindustries.registry.game.LTXINetworkSerializers;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.registry.game.LTXIRecipeSerializers;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import liedge.ltxindustries.util.config.LTXIClientConfig;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import liedge.ltxindustries.util.config.LTXIServerConfig;
import liedge.ltxindustries.util.config.LTXIWeaponsConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="ltxi")
public class LTXIndustries {
    public static final String MODID = "ltxi";
    public static final ModResources RESOURCES = new ModResources("ltxi");
    public static final Logger LOGGER = LogUtils.getLogger();

    public LTXIndustries(IEventBus modBus, ModContainer modContainer) {
        LTXIAttachmentTypes.register(modBus);
        LTXIBlockEntities.register(modBus);
        LTXIBlocks.register(modBus);
        LTXICreativeTabs.register(modBus);
        LTXIDataComponents.register(modBus);
        LTXIEntities.register(modBus);
        LTXIEntityUpgradeEffects.register(modBus);
        LTXIFluids.register(modBus);
        LTXIGameEvents.register(modBus);
        LTXIItems.register(modBus);
        LTXILootRegistries.register(modBus);
        LTXIMenus.register(modBus);
        LTXIMobEffects.register(modBus);
        LTXINetworkSerializers.register(modBus);
        LTXIParticles.register(modBus);
        LTXIRecipeSerializers.register(modBus);
        LTXIRecipeTypes.register(modBus);
        LTXISounds.register(modBus);
        LTXIUpgradeEffectComponents.register(modBus);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)LTXIClientConfig.CLIENT_CONFIG_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)LTXIServerConfig.SERVER_CONFIG_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)LTXIWeaponsConfig.WEAPONS_CONFIG_SPEC, "ltxi-weapons.toml");
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)LTXIMachinesConfig.MACHINES_CONFIG_SPEC, "ltxi-machines.toml");
        modBus.register((Object)new CommonSetup());
    }

    private static class CommonSetup {
        private CommonSetup() {
        }

        @SubscribeEvent
        private void onConfigLoaded(ModConfigEvent event) {
            LTXIClientConfig.reCacheConfigValues(event);
        }

        @SubscribeEvent
        private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar(LTXIndustries.MODID);
            LimaNetworkUtil.registerPlayToClient((PayloadRegistrar)registrar, ClientboundWeaponControlsPacket.TYPE, ClientboundWeaponControlsPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToClient((PayloadRegistrar)registrar, ClientboundFocusTargetPacket.TYPE, ClientboundFocusTargetPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToServer((PayloadRegistrar)registrar, ServerboundItemModeSwitchPacket.TYPE, ServerboundItemModeSwitchPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToServer((PayloadRegistrar)registrar, ServerboundWeaponControlsPacket.TYPE, ServerboundWeaponControlsPacket.STREAM_CODEC);
        }

        @SubscribeEvent
        private void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.registerEntity(LTXICapabilities.ENTITY_BUBBLE_SHIELD, EntityType.PLAYER, (player, $) -> (BubbleShieldUser)player.getData(LTXIAttachmentTypes.BUBBLE_SHIELD));
        }

        @SubscribeEvent
        private void registerGameObjects(RegisterEvent event) {
            event.register(Registries.FLUID, LTXIFluids::registerFluids);
        }

        @SubscribeEvent
        private void registerCustomRegistries(NewRegistryEvent event) {
            event.register(LTXIRegistries.UPGRADE_COMPONENT_TYPES);
            event.register(LTXIRegistries.ENTITY_UPGRADE_EFFECT_TYPES);
        }

        @SubscribeEvent
        private void registerDataPackRegistries(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(LTXIRegistries.Keys.EQUIPMENT_UPGRADES, EquipmentUpgrade.DIRECT_CODEC, EquipmentUpgrade.DIRECT_CODEC);
            event.dataPackRegistry(LTXIRegistries.Keys.MACHINE_UPGRADES, MachineUpgrade.DIRECT_CODEC, MachineUpgrade.DIRECT_CODEC);
            event.dataPackRegistry(LTXIRegistries.Keys.RECIPE_MODES, RecipeMode.DIRECT_CODEC, RecipeMode.DIRECT_CODEC);
        }
    }
}

