/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import liedge.limacore.block.LimaEntityBlock;
import liedge.ltxindustries.item.LTXIItemAbilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public abstract class BaseWrenchEntityBlock
extends LimaEntityBlock {
    protected BaseWrenchEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    protected BlockState handleWrenchRotation(Level level, BlockPos pos, BlockState state) {
        Direction oldFront = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)oldFront.getClockWise());
    }

    @Nullable
    protected BlockState handleWrenchDismantle(Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack tool, boolean simulate) {
        if (!level.isClientSide() && !simulate) {
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)tool);
        }
        return this.getFluidState(state).createLegacyBlock();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        ItemStack stack = context.getItemInHand();
        if (!stack.canPerformAction(itemAbility)) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (itemAbility == LTXIItemAbilities.WRENCH_ROTATE) {
            return this.handleWrenchRotation(level, pos, state);
        }
        if (itemAbility == LTXIItemAbilities.WRENCH_DISMANTLE) {
            return this.handleWrenchDismantle(level, pos, state, context.getPlayer(), stack, simulate);
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.canPerformAction(LTXIItemAbilities.WRENCH_ROTATE) || stack.canPerformAction(LTXIItemAbilities.WRENCH_DISMANTLE)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

