/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class GloomShroomBlock
extends BushBlock
implements SculkBehaviour {
    private static final VoxelShape SHAPE = LimaBlockUtil.dimensionBox((double)3.0, (double)0.0, (double)3.0, (double)10.0, (double)13.0, (double)10.0);

    public GloomShroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(Blocks.SCULK);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        TriState soilDecision = belowState.canSustainPlant((BlockGetter)level, belowPos, Direction.UP, state);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return belowState.is(Blocks.SCULK) && !level.canSeeSky(pos);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return FungusBlock.CODEC;
    }

    public int attemptUseCharge(SculkSpreader.ChargeCursor cursor, LevelAccessor level, BlockPos catalystPos, RandomSource random, SculkSpreader spreader, boolean shouldConvertBlocks) {
        BlockPos cursorPos;
        List<BlockPos> spacesToGrow;
        int charge = cursor.getCharge();
        if (charge != 0 && random.nextFloat() <= 0.33333f && !(spacesToGrow = BlockPos.betweenClosedStream((BlockPos)(cursorPos = cursor.getPos()).offset(-1, -1, -1), (BlockPos)cursorPos.offset(1, 1, 1)).filter(bp -> this.canGrowOn(level, (BlockPos)bp)).map(BlockPos::immutable).toList()).isEmpty()) {
            BlockPos placePos = spacesToGrow.get(random.nextInt(spacesToGrow.size())).above();
            level.setBlock(placePos, ((GloomShroomBlock)((Object)LTXIBlocks.GLOOM_SHROOM.get())).defaultBlockState(), 3);
            level.playSound(null, placePos, SoundEvents.FUNGUS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return charge - 1;
        }
        return charge;
    }

    public boolean canChangeBlockStateOnSpread() {
        return false;
    }

    private boolean canGrowOn(LevelAccessor level, BlockPos sculkPos) {
        if (!level.getBlockState(sculkPos).is(Blocks.SCULK)) {
            return false;
        }
        BlockPos pos = sculkPos.above();
        BlockState state = level.getBlockState(pos);
        FluidState fluidState = level.getFluidState(pos);
        return state.canBeReplaced() && !fluidState.isSource();
    }
}

