/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.menu.LimaMenuProvider;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.block.BaseMeshBlock;
import liedge.ltxindustries.block.PrimaryMeshBlock;
import liedge.ltxindustries.block.mesh.MeshPosition;
import liedge.ltxindustries.blockentity.MeshBlockEntity;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class MeshBlock
extends BaseMeshBlock {
    public MeshBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return null;
    }

    public LimaBlockEntityType<?> getBlockEntityType(BlockState state) {
        return (LimaBlockEntityType)LTXIBlockEntities.MESH_BLOCK.get();
    }

    @Nullable
    public LimaMenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockPos primaryPos = this.getPrimaryPos((LevelReader)level, pos, state);
        return primaryPos != null ? this.blockEntityMenuProvider(level, primaryPos) : null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockState primaryState;
        Block block;
        BlockPos primaryPos = this.getPrimaryPos(level, pos, state);
        if (primaryPos != null && (block = (primaryState = level.getBlockState(primaryPos)).getBlock()) instanceof PrimaryMeshBlock) {
            PrimaryMeshBlock primaryMeshBlock = (PrimaryMeshBlock)block;
            return primaryMeshBlock.getCloneItemStack(primaryState, target, level, primaryPos, player);
        }
        return ItemStack.EMPTY;
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockPos primaryPos;
        if (level instanceof LevelReader && (primaryPos = this.getPrimaryPos((LevelReader)level, pos, state)) != null) {
            return level.getBlockState(primaryPos).getDestroyProgress(player, level, primaryPos);
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockState primaryState;
            BlockPos primaryPos = this.getPrimaryPos((LevelReader)level, pos, state);
            if (primaryPos != null && (primaryState = level.getBlockState(primaryPos)).getBlock() instanceof PrimaryMeshBlock) {
                level.removeBlock(primaryPos, false);
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState primaryState;
        BlockPos primaryPos = this.getPrimaryPos((LevelReader)level, pos, state);
        if (primaryPos != null && (primaryState = level.getBlockState(primaryPos)).getBlock() instanceof PrimaryMeshBlock) {
            primaryState.getBlock().playerWillDestroy(level, primaryPos, primaryState, player);
            return state;
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState primaryState;
        if (willHarvest) {
            return true;
        }
        BlockPos primaryPos = this.getPrimaryPos((LevelReader)level, pos, state);
        if (primaryPos != null && (primaryState = level.getBlockState(primaryPos)).getBlock() instanceof PrimaryMeshBlock) {
            primaryState.onDestroyedByPlayer(level, primaryPos, player, false, fluid);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, false, fluid);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        BlockPos primaryPos = this.getPrimaryPos((LevelReader)level, pos, state);
        if (primaryPos != null) {
            BlockState primaryState = level.getBlockState(primaryPos);
            if (primaryState.getBlock() instanceof PrimaryMeshBlock) {
                primaryState.getBlock().playerDestroy(level, player, primaryPos, primaryState, level.getBlockEntity(primaryPos), tool);
            }
        } else {
            super.playerDestroy(level, player, pos, state, blockEntity, tool);
        }
        level.removeBlock(pos, false);
    }

    @Override
    protected BlockState handleWrenchDismantle(Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack tool, boolean simulate) {
        BlockState primaryState;
        Block block;
        BlockPos primaryPos = this.getPrimaryPos((LevelReader)level, pos, state);
        if (primaryPos != null && (block = (primaryState = level.getBlockState(primaryPos)).getBlock()) instanceof PrimaryMeshBlock) {
            PrimaryMeshBlock primaryMeshBlock = (PrimaryMeshBlock)block;
            primaryMeshBlock.handleWrenchDismantle(level, primaryPos, primaryState, player, tool, simulate);
        }
        return this.getFluidState(state).createLegacyBlock();
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        MeshBlockEntity blockEntity = (MeshBlockEntity)((Object)LimaBlockUtil.getBlockEntity((BlockGetter)level, (BlockPos)pos, MeshBlockEntity.class));
        if (blockEntity != null) {
            Block block;
            BlockPos primaryPos = blockEntity.getPrimaryPos(pos, state);
            MeshPosition meshPosition = blockEntity.getMeshPosition();
            if (primaryPos != null && meshPosition != null && (block = level.getBlockState(primaryPos).getBlock()) instanceof PrimaryMeshBlock) {
                PrimaryMeshBlock primaryBlock = (PrimaryMeshBlock)block;
                return primaryBlock.getMeshBlockShape((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), meshPosition);
            }
        }
        return Shapes.empty();
    }

    @Nullable
    private BlockPos getPrimaryPos(LevelReader level, BlockPos pos, BlockState state) {
        MeshBlockEntity blockEntity = (MeshBlockEntity)((Object)LimaBlockUtil.getSafeBlockEntity((LevelReader)level, (BlockPos)pos, MeshBlockEntity.class));
        return blockEntity != null ? blockEntity.getPrimaryPos(pos, state) : null;
    }
}

