/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.function.BiFunction;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.block.BaseMeshBlock;
import liedge.ltxindustries.block.MeshBlock;
import liedge.ltxindustries.block.mesh.BlockMesh;
import liedge.ltxindustries.block.mesh.LTXIBlockMeshes;
import liedge.ltxindustries.block.mesh.MeshPosition;
import liedge.ltxindustries.blockentity.MeshBlockEntity;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PrimaryMeshBlock
extends BaseMeshBlock {
    private final BlockMesh blockMesh;
    private final BiFunction<Direction, MeshPosition, VoxelShape> shapeFunction;
    private final boolean tickClient;

    private static int shapeKey(Vec3i pos, Direction facing) {
        int x = pos.getX() + 15;
        int y = pos.getY() + 15;
        int z = pos.getZ() + 15;
        return x << 12 | y << 7 | z << 2 | facing.get2DDataValue();
    }

    public static PrimaryMeshBlock create(BlockBehaviour.Properties properties, ResourceLocation blockMeshId, VoxelShape identityShape, boolean tickClient) {
        BlockMesh mesh = Objects.requireNonNull(LTXIBlockMeshes.getBlockMesh(blockMeshId));
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (Direction side2 : Direction.Plane.HORIZONTAL) {
            VoxelShape rotatedIdentity = LimaBlockUtil.rotateYClockwise((VoxelShape)identityShape, (int)LimaBlockUtil.rotationYFromDirection((Direction)side2));
            for (MeshPosition position : mesh.getMeshPositions()) {
                int key = PrimaryMeshBlock.shapeKey(position.pos(), side2);
                Vec3i offset = mesh.computeMeshOffset(position, mesh.getPrimary(), side2.getOpposite());
                VoxelShape shape = LimaBlockUtil.moveShape((VoxelShape)rotatedIdentity, (double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
                map.put(key, (Object)shape);
            }
        }
        Int2ObjectMap shapeMap = Int2ObjectMaps.unmodifiable((Int2ObjectMap)map);
        return new PrimaryMeshBlock(properties, mesh, (side, meshPos) -> (VoxelShape)shapeMap.getOrDefault(PrimaryMeshBlock.shapeKey(meshPos.pos(), side), (Object)Shapes.empty()), tickClient);
    }

    private PrimaryMeshBlock(BlockBehaviour.Properties properties, BlockMesh blockMesh, BiFunction<Direction, MeshPosition, VoxelShape> shapeFunction, boolean tickClient) {
        super(properties);
        this.blockMesh = blockMesh;
        this.shapeFunction = shapeFunction;
        this.tickClient = tickClient;
    }

    public BlockMesh getBlockMesh() {
        return this.blockMesh;
    }

    public VoxelShape getMeshBlockShape(Direction facing, MeshPosition meshPosition) {
        return this.shapeFunction.apply(facing, meshPosition);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeFunction.apply((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), this.blockMesh.getPrimary());
    }

    protected boolean shouldTickServer(BlockState state) {
        return true;
    }

    protected boolean shouldTickClient(BlockState state) {
        return this.tickClient;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos origin = context.getClickedPos();
        Direction zAxis = context.getHorizontalDirection();
        BlockMesh mesh = this.getBlockMesh();
        if (mesh.canPlaceMesh(level, origin, mesh.getPrimary(), zAxis)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)zAxis.getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(origin).is((Fluid)Fluids.WATER)));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockMesh mesh = this.getBlockMesh();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        mesh.meshStream(pos, mesh.getPrimary(), facing.getOpposite()).filter(cursor -> !cursor.equals(pos)).forEach(cursor -> {
            BlockState cursorState = (BlockState)((BlockState)((MeshBlock)((Object)((Object)LTXIBlocks.MESH_BLOCK.get()))).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState((BlockPos)cursor).is((Fluid)Fluids.WATER)));
            level.setBlockAndUpdate((BlockPos)cursor, cursorState);
            MeshBlockEntity blockEntity = (MeshBlockEntity)((Object)((Object)LimaBlockUtil.getSafeBlockEntity((LevelReader)level, (BlockPos)cursor, MeshBlockEntity.class)));
            if (blockEntity != null) {
                blockEntity.setBlockMesh(mesh);
                blockEntity.setMeshPosition(cursor.getMeshPosition());
                blockEntity.setChanged();
            }
        });
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.is((Block)this) && !newState.is((Block)this)) {
            BlockMesh mesh = this.getBlockMesh();
            mesh.meshStream(pos, mesh.getPrimary(), ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite()).filter(cursor -> !cursor.equals(pos)).forEach(cursor -> level.removeBlock((BlockPos)cursor, false));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

