/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import liedge.limacore.util.LimaBlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public class SparkFruitBlock
extends Block
implements BonemealableBlock {
    private static final VoxelShape AGE_0_SHAPE = LimaBlockUtil.dimensionBox((double)5.5, (double)7.0, (double)5.5, (double)5.0, (double)9.0, (double)5.0);
    private static final VoxelShape AGE_1_SHAPE = LimaBlockUtil.dimensionBox((double)5.5, (double)4.0, (double)5.5, (double)5.0, (double)12.0, (double)5.0);
    private static final VoxelShape AGE_2_SHAPE = LimaBlockUtil.dimensionBox((double)4.5, (double)2.0, (double)4.5, (double)7.0, (double)14.0, (double)7.0);

    public SparkFruitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(0)));
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)BlockStateProperties.AGE_2) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BlockStateProperties.AGE_2) + 1)), 2);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)BlockStateProperties.AGE_2) < 2;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)BlockStateProperties.AGE_2);
        if (age < 2 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (level.random.nextInt(8) == 0 ? 1 : 0) != 0)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(age + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        if (level.isOutsideBuildHeight(abovePos)) {
            return false;
        }
        BlockState aboveState = level.getBlockState(abovePos);
        TriState soilDecision = aboveState.canSustainPlant((BlockGetter)level, abovePos, Direction.DOWN, state);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return aboveState.is(Blocks.JUNGLE_LEAVES);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level;
        BlockState defaultState = this.defaultBlockState();
        return this.canSurvive(defaultState, (LevelReader)(level = context.getLevel()), pos = context.getClickedPos()) ? defaultState : null;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.UP && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.getValue((Property)BlockStateProperties.AGE_2);
        return switch (age) {
            case 1 -> AGE_1_SHAPE;
            case 2 -> AGE_2_SHAPE;
            default -> AGE_0_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.AGE_2});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

