/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import java.util.Map;
import java.util.function.Function;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.block.BaseWrenchEntityBlock;
import liedge.ltxindustries.block.LTXIBlockProperties;
import liedge.ltxindustries.block.MachineState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StateMachineBlock
extends BaseWrenchEntityBlock
implements SimpleWaterloggedBlock {
    private final Function<Direction, VoxelShape> shapeFunction;
    private final boolean tickClient;

    public static StateMachineBlock staticShape(BlockBehaviour.Properties properties, VoxelShape shape, boolean tickClient) {
        return new StateMachineBlock(properties, $ -> shape, tickClient);
    }

    public static StateMachineBlock rotatingShape(BlockBehaviour.Properties properties, VoxelShape referenceShape, boolean tickClient) {
        Map shapeMap = LimaBlockUtil.createHorizontalShapeMap((VoxelShape)referenceShape);
        return new StateMachineBlock(properties, shapeMap::get, tickClient);
    }

    private StateMachineBlock(BlockBehaviour.Properties properties, Function<Direction, VoxelShape> shapeFunction, boolean tickClient) {
        super(properties);
        this.shapeFunction = shapeFunction;
        this.tickClient = tickClient;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(LTXIBlockProperties.BINARY_MACHINE_STATE, (Comparable)((Object)MachineState.IDLE))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean shouldTickServer(BlockState state) {
        return true;
    }

    protected boolean shouldTickClient(BlockState state) {
        return this.tickClient;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(LTXIBlockProperties.BINARY_MACHINE_STATE, (Comparable)((Object)MachineState.IDLE))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, LTXIBlockProperties.BINARY_MACHINE_STATE, BlockStateProperties.WATERLOGGED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeFunction.apply((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

