/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import liedge.limacore.util.LimaBlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SurfaceStickingBlock
extends Block
implements SimpleWaterloggedBlock {
    private final Map<Direction, VoxelShape> shapeMap;
    private final boolean needsSturdyFace;

    public SurfaceStickingBlock(BlockBehaviour.Properties properties, VoxelShape identityShape, boolean needsSturdyFace) {
        super(properties);
        this.shapeMap = SurfaceStickingBlock.createShapeMap(identityShape);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.needsSturdyFace = needsSturdyFace;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeMap.get(state.getValue((Property)BlockStateProperties.FACING));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        BlockPos placedOnPos = pos.relative(facing.getOpposite());
        BlockState placedOnState = level.getBlockState(placedOnPos);
        return placedOnState.isFaceSturdy((BlockGetter)level, placedOnPos, facing);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean waterlogged = level.getFluidState(pos).is((Fluid)Fluids.WATER);
        BlockState placeState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
        return this.canSurvive(placeState, (LevelReader)level, pos) ? placeState : null;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (this.needsSturdyFace && direction == ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite() && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private static Map<Direction, VoxelShape> createShapeMap(VoxelShape identity) {
        EnumMap<Direction, VoxelShape> map = new EnumMap<Direction, VoxelShape>(Direction.class);
        map.put(Direction.UP, identity);
        map.put(Direction.DOWN, LimaBlockUtil.rotateXClockwise((VoxelShape)identity, (int)180));
        VoxelShape north = LimaBlockUtil.rotateZClockWise((VoxelShape)identity, (int)270);
        Direction.Plane.HORIZONTAL.forEach(facing -> map.put((Direction)facing, LimaBlockUtil.rotateYClockwise((VoxelShape)north, (int)LimaBlockUtil.rotationYFromDirection((Direction)facing))));
        return ImmutableMap.copyOf(map);
    }
}

