/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block.mesh;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import liedge.ltxindustries.block.mesh.BlockMeshPartType;
import liedge.ltxindustries.block.mesh.MeshPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;

public final class BlockMesh {
    private final List<MeshPosition> meshPositions;
    private final MeshPosition primary;

    static Builder builder() {
        return new Builder();
    }

    BlockMesh(List<MeshPosition> meshPositions, MeshPosition primary) {
        this.meshPositions = meshPositions;
        this.primary = primary;
    }

    public MeshPosition getPrimary() {
        return this.primary;
    }

    public List<MeshPosition> getMeshPositions() {
        return this.meshPositions;
    }

    public MeshPosition getMeshPosition(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.meshPositions.size(), (String)"Mesh Positions");
        return this.meshPositions.get(index);
    }

    public boolean canPlaceMesh(Level level, BlockPos origin, MeshPosition meshPosition, Direction zAxis) {
        int buildLimit = level.getMaxBuildHeight() - 1;
        return this.meshStream(origin, meshPosition, zAxis).allMatch(mp -> mp.getY() < buildLimit && level.getBlockState((BlockPos)mp).canBeReplaced());
    }

    public BlockPos getPrimaryBlockPos(BlockPos pos, MeshPosition from, Direction zAxis) {
        return this.getRelativeBlockPos(pos, from, this.primary, zAxis);
    }

    public BlockPos getRelativeBlockPos(BlockPos blockPos, MeshPosition from, MeshPosition to, Direction zAxis) {
        Vec3i offset = this.computeMeshOffset(from, to, zAxis);
        return blockPos.offset(offset);
    }

    public Vec3i computeMeshOffset(MeshPosition from, MeshPosition to, Direction zAxis) {
        Direction xAxis = zAxis.getCounterClockWise();
        Vec3i delta = to.subtract(from);
        int x = xAxis.getStepX() * delta.getX() + zAxis.getStepX() * delta.getZ();
        int y = delta.getY();
        int z = xAxis.getStepZ() * delta.getX() + zAxis.getStepZ() * delta.getZ();
        return new Vec3i(x, y, z);
    }

    public Stream<MeshBlockPos> meshStream(BlockPos blockPos, MeshPosition meshPosition, Direction zAxis) {
        return StreamSupport.stream(this.meshIterable(blockPos, meshPosition, zAxis).spliterator(), false);
    }

    public Iterable<MeshBlockPos> meshIterable(BlockPos blockPos, MeshPosition meshPosition, final Direction zAxis) {
        final BlockPos primaryPos = this.getPrimaryBlockPos(blockPos, meshPosition, zAxis);
        final Direction xAxis = zAxis.getCounterClockWise();
        return () -> new Iterator<MeshBlockPos>(){
            private final MeshBlockPos cursor = new MeshBlockPos();
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < BlockMesh.this.meshPositions.size();
            }

            @Override
            public MeshBlockPos next() {
                MeshPosition next = BlockMesh.this.meshPositions.get(this.current);
                int x = primaryPos.getX() + xAxis.getStepX() * next.pos().getX() + zAxis.getStepX() * next.pos().getZ();
                int y = primaryPos.getY() + next.pos().getY();
                int z = primaryPos.getZ() + xAxis.getStepZ() * next.pos().getX() + zAxis.getStepZ() * next.pos().getZ();
                this.cursor.setMeshPosition(next);
                this.cursor.set(x, y, z);
                ++this.current;
                return this.cursor;
            }
        };
    }

    static class Builder {
        private final ObjectList<MeshPosition> meshPositions = new ObjectArrayList();
        private final Set<Vec3i> usedPos = new ObjectOpenHashSet();

        Builder() {
        }

        public Builder add(int x, int y, int z, BlockMeshPartType type) {
            Vec3i pos = new Vec3i(x, y, z);
            if (!this.usedPos.add(pos)) {
                throw new IllegalArgumentException("Mesh position " + String.valueOf(pos) + " already used.");
            }
            MeshPosition position = new MeshPosition(this.meshPositions.size(), pos, type);
            this.meshPositions.add((Object)position);
            return this;
        }

        public Builder add(int x, int y, int z) {
            return this.add(x, y, z, BlockMeshPartType.DUMMY);
        }

        public BlockMesh build() {
            List<MeshPosition> primaries = this.meshPositions.stream().filter(o -> o.type() == BlockMeshPartType.PRIMARY).toList();
            Preconditions.checkState((primaries.size() == 1 ? 1 : 0) != 0, (Object)("Block mesh contains invalid number of primary positions: " + primaries.size()));
            return new BlockMesh((List<MeshPosition>)ObjectLists.unmodifiable(this.meshPositions), primaries.getFirst());
        }
    }

    public static final class MeshBlockPos
    extends BlockPos.MutableBlockPos {
        private MeshPosition meshPosition;

        public void setMeshPosition(MeshPosition meshPosition) {
            this.meshPosition = meshPosition;
        }

        public MeshPosition getMeshPosition() {
            return this.meshPosition;
        }
    }
}

