/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.block.mesh;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Objects;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.block.mesh.BlockMesh;
import liedge.ltxindustries.block.mesh.BlockMeshPartType;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class LTXIBlockMeshes {
    public static final ResourceLocation WIDE_STATION = LTXIndustries.RESOURCES.location("wide_station");
    public static final ResourceLocation DOUBLE_VERTICAL = LTXIndustries.RESOURCES.location("double_vertical");
    public static final ResourceLocation TRIPLE_VERTICAL = LTXIndustries.RESOURCES.location("triple_vertical");
    private static final BiMap<ResourceLocation, BlockMesh> REGISTRY = (BiMap)Util.make(() -> {
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        BlockMesh wideStation = BlockMesh.builder().add(0, 0, 0, BlockMeshPartType.PRIMARY).add(0, 1, 0).add(-1, 0, 0).add(-1, 1, 0).build();
        BlockMesh doubleVertical = BlockMesh.builder().add(0, 0, 0, BlockMeshPartType.PRIMARY).add(0, 1, 0).build();
        BlockMesh tripleVertical = BlockMesh.builder().add(0, 0, 0, BlockMeshPartType.PRIMARY).add(0, 1, 0).add(0, 2, 0).build();
        builder.put((Object)WIDE_STATION, (Object)wideStation);
        builder.put((Object)DOUBLE_VERTICAL, (Object)doubleVertical);
        builder.put((Object)TRIPLE_VERTICAL, (Object)tripleVertical);
        return builder.build();
    });

    private LTXIBlockMeshes() {
    }

    @Nullable
    public static BlockMesh getBlockMesh(ResourceLocation id) {
        return (BlockMesh)REGISTRY.get((Object)id);
    }

    public static ResourceLocation getBlockMeshId(BlockMesh mesh) {
        return Objects.requireNonNull((ResourceLocation)REGISTRY.inverse().get((Object)mesh), "Unregistered mesh.");
    }
}

