/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import java.util.Optional;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.util.LimaRecipesUtil;
import liedge.ltxindustries.blockentity.BaseFabricatorBlockEntity;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class AutoFabricatorBlockEntity
extends BaseFabricatorBlockEntity {
    private boolean shouldCheckRecipe;
    private boolean shouldCheckBlueprint;

    public AutoFabricatorBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.AUTO_FABRICATOR.get()), pos, state, 16);
    }

    private void updateBlueprint(Level level) {
        this.shouldCheckBlueprint = false;
        ItemStack bpItem = this.getAuxInventory().getStackInSlot(2);
        ResourceLocation bpId = (ResourceLocation)bpItem.get(LTXIDataComponents.BLUEPRINT_RECIPE);
        RecipeHolder holder = null;
        if (bpId != null) {
            holder = LimaRecipesUtil.getRecipeById((Level)level, (ResourceLocation)bpId, LTXIRecipeTypes.FABRICATING).orElse(null);
        }
        this.getRecipeCheck().setLastUsedRecipe(holder);
    }

    @Override
    protected void tickServerFabricator(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.shouldCheckBlueprint && !this.isCrafting()) {
            this.updateBlueprint((Level)level);
        }
        if (this.shouldCheckRecipe && !this.isCrafting()) {
            this.shouldCheckRecipe = false;
            Optional optional = this.getRecipeCheck().getLastUsedRecipe((Level)level);
            boolean check = false;
            if (optional.isPresent()) {
                FabricatingRecipe recipe = (FabricatingRecipe)((RecipeHolder)optional.get()).value();
                LimaRecipeInput input = LimaRecipeInput.create((IItemHandler)this.getInputInventory(), null);
                if (this.canInsertRecipeResults((Level)level, recipe) && recipe.matches(input, (Level)level)) {
                    recipe.consumeItemIngredients(input, level.getRandom());
                    check = true;
                }
            }
            this.setCrafting(check);
        }
        FabricatingRecipe recipe = this.getRecipeCheck().getLastUsedRecipe((Level)level).map(RecipeHolder::value).orElse(null);
        if (this.isCrafting() && recipe != null && this.canInsertRecipeResults((Level)level, recipe)) {
            if (this.energyCraftProgress < recipe.getEnergyRequired()) {
                int toExtract = Math.min(this.getEnergyUsage(), recipe.getEnergyRequired() - this.energyCraftProgress);
                this.energyCraftProgress += this.getEnergyStorage().extractEnergy(toExtract, false);
            } else {
                this.getOutputInventory().insertItem(0, recipe.generateItemResult(level), false);
                this.energyCraftProgress = 0;
                this.setCrafting(false);
                this.shouldCheckRecipe = true;
            }
        } else {
            this.energyCraftProgress = 0;
        }
    }

    @Override
    public Item getValidBlueprintItem() {
        return (Item)LTXIItems.FABRICATION_BLUEPRINT.get();
    }

    public void onItemSlotChanged(BlockContentsType contentsType, int slot) {
        super.onItemSlotChanged(contentsType, slot);
        if (contentsType == BlockContentsType.INPUT || contentsType == BlockContentsType.OUTPUT) {
            this.shouldCheckRecipe = true;
        } else if (contentsType == BlockContentsType.AUXILIARY && slot == 2) {
            this.shouldCheckRecipe = true;
            this.shouldCheckBlueprint = true;
        }
    }
}

