/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import java.util.EnumMap;
import java.util.Map;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.capability.energy.LimaEnergyStorage;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.menu.BlockEntityMenuType;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.util.LimaItemUtil;
import liedge.ltxindustries.block.EnergyCellArrayBlock;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.EnergyMachineBlockEntity;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BaseECABlockEntity
extends EnergyMachineBlockEntity {
    private final LimaBlockEntityItemHandler chargingInventory;
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> energyConnections = new EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>(Direction.class);

    public BaseECABlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, @Nullable LimaEnergyStorage energyStorage) {
        super(type, pos, state, energyStorage);
        this.chargingInventory = new LimaBlockEntityItemHandler((ItemHolderBlockEntity)this, 4, BlockContentsType.GENERAL);
    }

    public abstract LimaColor getRemoteEnergyFillColor();

    public abstract float getRemoteEnergyFill();

    @Override
    public boolean hasStatsTooltips() {
        return false;
    }

    @Nullable
    public LimaBlockEntityItemHandler getItemHandler(BlockContentsType contentsType) {
        return switch (contentsType) {
            case BlockContentsType.GENERAL -> this.chargingInventory;
            case BlockContentsType.AUXILIARY -> this.getAuxInventory();
            default -> null;
        };
    }

    @Override
    public boolean isItemValid(BlockContentsType contentsType, int slot, ItemStack stack) {
        return contentsType == BlockContentsType.GENERAL ? LimaItemUtil.hasEnergyCapability((ItemStack)stack) : super.isItemValid(contentsType, slot, stack);
    }

    public IOAccess getItemHandlerSlotIO(BlockContentsType contentsType, int slot) {
        return contentsType == BlockContentsType.GENERAL ? this.checkStackEnergy(this.chargingInventory.getStackInSlot(slot)) : IOAccess.DISABLED;
    }

    private IOAccess checkStackEnergy(ItemStack stack) {
        if (stack.isEmpty()) {
            return IOAccess.INPUT_ONLY;
        }
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (storage == null || storage.getEnergyStored() >= storage.getMaxEnergyStored()) {
            return IOAccess.OUTPUT_ONLY;
        }
        return IOAccess.DISABLED;
    }

    @Nullable
    public IItemHandler createItemIOWrapper(@Nullable Direction side) {
        return this.chargingInventory.createIOWrapper(this.getSideIOForItems(side));
    }

    @Override
    @Nullable
    public IEnergyStorage getNeighborEnergyStorage(Direction side) {
        return (IEnergyStorage)this.energyConnections.get(side).getCapability();
    }

    protected void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        this.fillEnergyBuffer();
        LimaEnergyStorage machineEnergy = this.getEnergyStorage();
        if (machineEnergy.getEnergyStored() > 0) {
            for (int i = 0; i < this.chargingInventory.getSlots(); ++i) {
                ItemStack stack2 = this.chargingInventory.getStackInSlot(i);
                IEnergyStorage stackEnergy = (IEnergyStorage)stack2.getCapability(Capabilities.EnergyStorage.ITEM);
                if (stackEnergy == null) continue;
                LimaEnergyUtil.transferEnergyBetween((IEnergyStorage)machineEnergy, (IEnergyStorage)stackEnergy, (int)machineEnergy.getEnergyStored(), (boolean)false);
            }
        }
        this.autoOutputItems(100, (IItemHandler)this.chargingInventory, stack -> this.checkStackEnergy((ItemStack)stack).allowsOutput());
        this.autoOutputEnergy();
    }

    @Override
    protected void createConnectionCaches(ServerLevel level, Direction side) {
        super.createConnectionCaches(level, side);
        this.energyConnections.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)this.createCapabilityCache(Capabilities.EnergyStorage.BLOCK, level, side));
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
    }

    public Component getMenuTitle(BlockEntityMenuType<?, ?> menuType) {
        return ((EnergyCellArrayBlock)((Object)LTXIBlocks.ENERGY_CELL_ARRAY.get())).getName();
    }
}

