/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import java.util.function.Supplier;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.recipe.LimaRecipeCheck;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaItemUtil;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.EnergyConsumerBlockEntity;
import liedge.ltxindustries.blockentity.base.RecipeMachineBlockEntity;
import liedge.ltxindustries.blockentity.template.ProductionMachineBlockEntity;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import liedge.ltxindustries.util.LTXITooltipUtil;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class BaseFabricatorBlockEntity
extends ProductionMachineBlockEntity
implements EnergyConsumerBlockEntity,
RecipeMachineBlockEntity<LimaRecipeInput, FabricatingRecipe> {
    public static final int AUX_BLUEPRINT_SLOT = 2;
    private final LimaRecipeCheck<LimaRecipeInput, FabricatingRecipe> recipeCheck = LimaRecipeCheck.create(LTXIRecipeTypes.FABRICATING);
    private int energyUsage = this.getBaseEnergyUsage();
    private boolean crafting;
    protected int energyCraftProgress;
    private ItemStack clientPreviewItem = ItemStack.EMPTY;

    protected BaseFabricatorBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, int inputSlots) {
        super(type, pos, state, 3, inputSlots, 1);
    }

    public ItemStack getClientPreviewItem() {
        return this.clientPreviewItem;
    }

    public int getEnergyCraftProgress() {
        return this.energyCraftProgress;
    }

    public LimaDataWatcher<Integer> keepProgressSynced() {
        return AutomaticDataWatcher.keepSynced((Supplier)LimaCoreNetworkSerializers.VAR_INT, this::getEnergyCraftProgress, i -> {
            this.energyCraftProgress = i;
        });
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.FABRICATOR_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public void appendStatsTooltips(TooltipLineConsumer consumer) {
        LTXITooltipUtil.appendEnergyUsagePerTickTooltip(consumer, this.getEnergyUsage());
    }

    @Override
    public void onUpgradeRefresh(LootContext context, MachineUpgrades upgrades) {
        super.onUpgradeRefresh(context, upgrades);
        EnergyConsumerBlockEntity.applyUpgrades(this, context, upgrades);
    }

    @Override
    public LimaRecipeCheck<LimaRecipeInput, FabricatingRecipe> getRecipeCheck() {
        return this.recipeCheck;
    }

    @Override
    public boolean canInsertRecipeResults(Level level, FabricatingRecipe recipe) {
        return LimaItemUtil.canMergeItemStacks((ItemStack)this.getOutputInventory().getStackInSlot(0), (ItemStack)recipe.getFabricatingResultItem());
    }

    @Override
    public boolean isCrafting() {
        return this.crafting;
    }

    @Override
    public void setCrafting(boolean crafting) {
        this.crafting = crafting;
        this.setChanged();
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(AutomaticDataWatcher.keepSynced((Supplier)LimaCoreNetworkSerializers.BOOL, this::isCrafting, this::setCrafting));
        collector.register(AutomaticDataWatcher.keepItemSynced(this::createPreviewItem, stack -> {
            this.clientPreviewItem = stack;
        }));
    }

    @Override
    public int getBaseEnergyUsage() {
        return LTXIMachinesConfig.FABRICATOR_ENERGY_USAGE.getAsInt();
    }

    @Override
    public int getEnergyUsage() {
        return this.energyUsage;
    }

    @Override
    public void setEnergyUsage(int energyUsage) {
        this.energyUsage = energyUsage;
    }

    protected void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        this.fillEnergyBuffer();
        this.tickServerFabricator(level, pos, state);
        this.autoOutputItems(20, (IItemHandler)this.getOutputInventory());
    }

    protected abstract void tickServerFabricator(ServerLevel var1, BlockPos var2, BlockState var3);

    public abstract Item getValidBlueprintItem();

    @Override
    protected boolean isItemValidForAuxInventory(int slot, ItemStack stack) {
        return slot == 2 ? stack.is(this.getValidBlueprintItem()) : super.isItemValidForAuxInventory(slot, stack);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        LimaNbtUtil.deserializeString(this.recipeCheck, (HolderLookup.Provider)registries, (Tag)tag.get("current_recipe"));
        this.crafting = tag.getBoolean("crafting");
        this.energyCraftProgress = tag.getInt("recipe_energy");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("current_recipe", (Tag)this.recipeCheck.serializeNBT(registries));
        tag.putBoolean("crafting", this.crafting);
        tag.putInt("recipe_energy", this.energyCraftProgress);
    }

    private ItemStack createPreviewItem() {
        ItemStack currentOutputItem = this.getOutputInventory().getStackInSlot(0);
        if (this.isCrafting()) {
            return this.recipeCheck.getLastUsedRecipe(this.level).map(r -> ((FabricatingRecipe)r.value()).getFabricatingResultItem()).orElse(currentOutputItem);
        }
        return currentOutputItem;
    }
}

