/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Supplier;
import liedge.limacore.blockentity.OwnableBlockEntity;
import liedge.limacore.capability.energy.LimaEnergyStorage;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.client.LimaCoreClientUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.network.sync.ManualDataWatcher;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaStreamsUtil;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.ProductionMachineBlockEntity;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.lib.TurretTargetList;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTurretBlockEntity
extends ProductionMachineBlockEntity
implements OwnableBlockEntity {
    protected final Queue<Entity> targetQueue = new ArrayDeque<Entity>();
    private final Vec3 projectileStart;
    private final AABB targetArea;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    protected Entity currentTarget;
    private LimaDataWatcher<IntList> targetsWatcher;
    private LimaDataWatcher<Boolean> activeWatcher;
    private boolean turretCharging;
    private boolean turretFiring;
    protected int ticker;
    private final AABB defaultRenderBox;
    private boolean activeClient;
    private int ticker0;
    private float turretYRot0;
    private float turretYRot;
    private float turretXRot0;
    private float turretXRot;
    private double targetDistance;
    private boolean lookingAtTarget;

    protected BaseTurretBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, double startY, double areaXZRadius, double areaYMin, double areaYMax) {
        super(type, pos, state, 2, 0, 20);
        this.projectileStart = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + startY, (double)pos.getZ() + 0.5);
        this.targetArea = new AABB(this.projectileStart.x - areaXZRadius, this.projectileStart.y - areaYMin, this.projectileStart.z - areaXZRadius, this.projectileStart.x + areaXZRadius, this.projectileStart.y + areaYMax, this.projectileStart.z + areaXZRadius);
        this.defaultRenderBox = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1));
    }

    protected abstract int getEnergyPerTarget();

    protected abstract int getTargetScanTime();

    protected abstract int getMaxTargetsPerScan();

    protected abstract int getFiringSequenceDelay();

    protected abstract boolean isValidTarget(Entity var1);

    protected abstract void serverTargetFiringTick(ServerLevel var1, BlockPos var2, BlockState var3, @Nullable Player var4, Entity var5, TurretTargetList var6);

    protected Comparator<Entity> targetsComparator() {
        return Comparator.comparingDouble(e -> e.distanceToSqr(this.projectileStart));
    }

    public Vec3 getProjectileStart() {
        return this.projectileStart;
    }

    public AABB getTargetArea() {
        return this.targetArea;
    }

    public AABB getDefaultRenderBox() {
        return this.defaultRenderBox;
    }

    public Collection<Entity> getTargetQueue() {
        return this.targetQueue;
    }

    public void onRemovedFromLevel(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
        TurretTargetList targetList = TurretTargetList.getOrDefault((Entity)this.getOwner());
        targetList.removeTarget(this.currentTarget);
        targetList.removeTargets(this.targetQueue);
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(AutomaticDataWatcher.keepClientsideEntitySynced(() -> this.currentTarget, entity -> {
            if (entity != null && !LTXIEntityUtil.isEntityAlive(entity)) {
                entity = null;
            }
            this.currentTarget = entity;
        }));
        this.targetsWatcher = ManualDataWatcher.manuallyTrack((Supplier)LimaCoreNetworkSerializers.INT_LIST, () -> LTXIEntityUtil.flattenEntityIds(this.targetQueue), list -> {
            this.targetQueue.clear();
            list.intStream().mapToObj(LimaCoreClientUtil::getClientEntity).filter(e -> e != null && LTXIEntityUtil.isEntityAlive(e)).forEach(this.targetQueue::add);
            this.ticker0 = 0;
            this.ticker = 0;
        });
        this.activeWatcher = ManualDataWatcher.manuallyTrack((Supplier)LimaCoreNetworkSerializers.BOOL, () -> this.getEnergyStorage().getEnergyStored() >= this.getEnergyPerTarget(), b -> {
            this.activeClient = b;
        });
        collector.register(this.targetsWatcher);
        collector.register(this.activeWatcher);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.setChanged();
    }

    public void onEnergyChanged(int previousEnergy) {
        this.setChanged();
        this.activeWatcher.setChanged(true);
    }

    protected void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        Player owner = this.getOwner();
        TurretTargetList targetList = TurretTargetList.getOrDefault((Entity)owner);
        LimaEnergyStorage energyStorage = this.getEnergyStorage();
        this.fillEnergyBuffer();
        this.autoOutputItems(100, (IItemHandler)this.getOutputInventory());
        if (!this.turretCharging && this.targetQueue.isEmpty() && this.ticker >= this.getTargetScanTime()) {
            int energyPerTarget = this.getEnergyPerTarget();
            int maxTargets = Math.min(this.getMaxTargetsPerScan(), energyStorage.getEnergyStored() / energyPerTarget);
            if (maxTargets > 0) {
                level.getProfiler().push("turretTargetScan");
                List foundTargets = (List)level.getEntities((Entity)owner, this.getTargetArea(), e -> LTXIEntityUtil.checkTurretTargetValidity((Entity)owner, e, this.getUpgrades(), this::isValidTarget) && !targetList.containsTarget((Entity)e)).stream().sorted(this.targetsComparator()).distinct().filter(e -> {
                    if (targetList.addTarget((Entity)e) && level.clip(new ClipContext(this.getProjectileStart(), e.getBoundingBox().getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, e)).getType() != HitResult.Type.BLOCK) {
                        return true;
                    }
                    targetList.removeTarget((Entity)e);
                    return false;
                }).limit(maxTargets).collect(LimaStreamsUtil.toObjectList());
                level.getProfiler().pop();
                if (!foundTargets.isEmpty()) {
                    LimaEnergyUtil.consumeEnergy((IEnergyStorage)energyStorage, (int)(energyPerTarget * foundTargets.size()), (boolean)true);
                    this.targetQueue.addAll(foundTargets);
                    level.playSound(null, pos, (SoundEvent)LTXISounds.TURRET_TARGET_FOUND.get(), SoundSource.BLOCKS, 1.5f, Mth.randomBetween((RandomSource)level.random, (float)0.9f, (float)1.0f));
                    this.targetsWatcher.setChanged(true);
                    this.turretCharging = true;
                }
            }
            this.ticker = 0;
        }
        if (this.turretCharging) {
            if (!this.turretFiring) {
                if (!this.targetQueue.isEmpty() && this.ticker >= this.getFiringSequenceDelay()) {
                    this.turretFiring = true;
                    this.ticker = 0;
                } else if (this.targetQueue.isEmpty()) {
                    this.turretFiring = false;
                    this.turretCharging = false;
                    this.ticker = 0;
                    this.targetsWatcher.setChanged(true);
                }
            } else if (this.currentTarget != null && LTXIEntityUtil.isEntityAlive(this.currentTarget)) {
                this.serverTargetFiringTick(level, pos, state, owner, this.currentTarget, targetList);
            } else {
                this.currentTarget = null;
                if (!this.targetQueue.isEmpty()) {
                    this.currentTarget = this.targetQueue.poll();
                } else {
                    this.turretCharging = false;
                    this.turretFiring = false;
                    this.targetsWatcher.setChanged(true);
                }
                this.ticker = 0;
            }
        }
        ++this.ticker;
    }

    protected void tickClient(Level level, BlockPos pos, BlockState state) {
        Entity target;
        if (!this.targetQueue.isEmpty() && this.ticker % 5 == 0) {
            this.targetQueue.removeIf(e -> !LTXIEntityUtil.isEntityAlive(e));
        }
        if ((target = this.currentTarget == null && !this.targetQueue.isEmpty() ? this.targetQueue.peek() : this.currentTarget) != null && LTXIEntityUtil.isEntityAlive(target)) {
            Vec3 start = this.getProjectileStart();
            Vec3 end = target.getBoundingBox().getCenter();
            this.targetDistance = start.distanceTo(end);
            double dx = end.x - start.x;
            double dy = end.y - start.y;
            double dz = end.z - start.z;
            this.turretYRot0 = this.turretYRot;
            float nextYRot = LimaCoreMath.toDeg((double)Mth.atan2((double)dz, (double)dx)) + 90.0f;
            if (!this.lookingAtTarget) {
                this.lookingAtTarget = Mth.degreesDifferenceAbs((float)this.turretYRot, (float)nextYRot) <= 10.0f;
            }
            this.turretYRot = Mth.approachDegrees((float)this.turretYRot, (float)nextYRot, (float)20.0f);
            this.turretXRot0 = this.turretXRot;
            this.turretXRot = Mth.approachDegrees((float)this.turretXRot, (float)LimaCoreMath.toDeg((double)Mth.atan2((double)dy, (double)LimaCoreMath.vec2Length((double)dx, (double)dz))), (float)10.0f);
            this.ticker0 = this.ticker++;
        } else {
            this.currentTarget = null;
            this.targetDistance = 0.0;
            this.lookingAtTarget = false;
            if (this.activeClient) {
                this.turretXRot0 = this.turretXRot;
                this.turretXRot = Mth.approachDegrees((float)this.turretXRot, (float)0.0f, (float)5.0f);
                this.turretYRot0 = this.turretYRot;
                this.turretYRot = (this.turretYRot - 2.0f) % 360.0f;
            } else {
                this.turretXRot0 = this.turretXRot;
                this.turretXRot = Mth.approachDegrees((float)this.turretXRot, (float)-30.0f, (float)10.0f);
                this.turretYRot0 = this.turretYRot;
                float angle = switch (this.getFacing()) {
                    case Direction.SOUTH -> 0.0f;
                    case Direction.EAST -> -90.0f;
                    case Direction.WEST -> 90.0f;
                    default -> 180.0f;
                };
                this.turretYRot = Mth.approachDegrees((float)this.turretYRot, (float)angle, (float)15.0f);
            }
        }
    }

    @Override
    public void appendStatsTooltips(TooltipLineConsumer consumer) {
        LTXITooltipUtil.appendEnergyUsageTooltip(consumer, this.getEnergyPerTarget());
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.setOwnerUUID((UUID)componentInput.get((Supplier)LimaCoreDataComponents.OWNER));
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((Supplier)LimaCoreDataComponents.OWNER, (Object)this.getOwnerUUID());
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("owner");
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadOwnerID(tag);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveOwnerID(tag);
    }

    public double getTargetDistance() {
        return this.targetDistance;
    }

    public boolean isLookingAtTarget() {
        return this.lookingAtTarget;
    }

    public float lerpYRot(float partialTick) {
        return -Mth.rotLerp((float)partialTick, (float)this.turretYRot0, (float)this.turretYRot);
    }

    public float lerpXRot(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.turretXRot0, (float)this.turretXRot);
    }

    public float lerpTicker(float partialTick, float maxTicks) {
        return Math.min(Mth.lerp((float)partialTick, (float)this.ticker0, (float)this.ticker) / maxTicks, 1.0f);
    }
}

