/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.limacore.util.LimaItemUtil;
import liedge.ltxindustries.block.LTXIBlockProperties;
import liedge.ltxindustries.block.MachineState;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.BaseRecipeMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CookingBlockEntity<R extends AbstractCookingRecipe>
extends BaseRecipeMachineBlockEntity<SingleRecipeInput, R> {
    protected CookingBlockEntity(ConfigurableIOBlockEntityType<?> type, RecipeType<R> recipeType, BlockPos pos, BlockState state) {
        super(type, recipeType, pos, state, 1, 1, 0, 0);
    }

    @Override
    protected SingleRecipeInput getRecipeInput(Level level) {
        return new SingleRecipeInput(this.getInputInventory().getStackInSlot(0));
    }

    @Override
    protected int getBaseRecipeCraftingTime(R recipe) {
        return recipe.getCookingTime();
    }

    @Override
    protected void consumeIngredients(SingleRecipeInput recipeInput, R recipe, Level level) {
        this.getInputInventory().extractItem(0, 1, false);
    }

    @Override
    public boolean canInsertRecipeResults(Level level, R recipe) {
        return LimaItemUtil.canMergeItemStacks((ItemStack)this.getOutputInventory().getStackInSlot(0), (ItemStack)recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    @Override
    protected void insertRecipeResults(Level level, R recipe, SingleRecipeInput recipeInput) {
        ItemStack result = recipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
        this.getOutputInventory().insertItem(0, result, false);
    }

    @Override
    protected void onCraftingStateChanged(boolean newCraftingState) {
        BlockState newState = (BlockState)this.getBlockState().setValue(LTXIBlockProperties.BINARY_MACHINE_STATE, (Comparable)((Object)MachineState.of(newCraftingState)));
        this.nonNullLevel().setBlockAndUpdate(this.getBlockPos(), newState);
    }
}

