/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.ltxindustries.block.LTXIBlockProperties;
import liedge.ltxindustries.block.MachineState;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.LTXIRecipeMachineBlockEntity;
import liedge.ltxindustries.recipe.ElectroCentrifugingRecipe;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ElectroCentrifugeBlockEntity
extends LTXIRecipeMachineBlockEntity.StateMachine<ElectroCentrifugingRecipe> {
    private int spinSpeed = 0;
    private float tubesYRot0;
    private float tubesYRot;

    public ElectroCentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.ELECTROCENTRIFUGE.get()), (RecipeType)LTXIRecipeTypes.ELECTRO_CENTRIFUGING.get(), pos, state, 1, 4, 1, 2);
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.ELECTROCENTRIFUGE_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public int getBaseEnergyUsage() {
        return LTXIMachinesConfig.ELECTROCENTRIFUGE_ENERGY_USAGE.getAsInt();
    }

    protected void tickClient(Level level, BlockPos pos, BlockState state) {
        if (((MachineState)((Object)state.getValue(LTXIBlockProperties.BINARY_MACHINE_STATE))).isActive()) {
            if (this.spinSpeed < 30) {
                this.spinSpeed += 3;
            }
            this.tubesYRot0 = this.tubesYRot;
            this.tubesYRot = (this.tubesYRot + (float)this.spinSpeed) % 360.0f;
        } else if (this.spinSpeed > 5) {
            --this.spinSpeed;
            this.tubesYRot0 = this.tubesYRot;
            this.tubesYRot = (this.tubesYRot + (float)this.spinSpeed) % 360.0f;
        } else {
            this.spinSpeed = 0;
            this.tubesYRot0 = this.tubesYRot;
            if (this.tubesYRot % 90.0f != 0.0f) {
                int n = 90 * Mth.ceil((float)(this.tubesYRot / 90.0f));
                this.tubesYRot = Mth.approachDegrees((float)this.tubesYRot, (float)n, (float)5.0f);
            }
        }
    }

    public float lerpTubesYRot(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.tubesYRot0, (float)this.tubesYRot);
    }
}

