/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import java.util.function.Supplier;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.blockentity.BaseECABlockEntity;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyCellArrayBlockEntity
extends BaseECABlockEntity {
    private int remoteEnergyFill;

    public EnergyCellArrayBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.ENERGY_CELL_ARRAY.get()), pos, state, null);
    }

    @Override
    public LimaColor getRemoteEnergyFillColor() {
        return LTXIConstants.REM_BLUE;
    }

    @Override
    public float getRemoteEnergyFill() {
        return (float)this.remoteEnergyFill / 20.0f;
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.ECA_BASE_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public int getBaseEnergyTransferRate() {
        return LTXIMachinesConfig.ECA_BASE_TRANSFER_RATE.getAsInt();
    }

    @Override
    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(AutomaticDataWatcher.keepSynced((Supplier)LimaCoreNetworkSerializers.VAR_INT, () -> Mth.floor((float)(LimaEnergyUtil.getClampedFillPercentage((IEnergyStorage)this.getEnergyStorage()) * 20.0f)), i -> {
            this.remoteEnergyFill = i;
        }));
    }
}

