/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.ltxindustries.item.EquipmentUpgradeModuleItem;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class EquipmentUpgradeStationBlockEntity
extends LimaBlockEntity
implements ItemHolderBlockEntity {
    public static final int EQUIPMENT_ITEM_SLOT = 0;
    public static final int UPGRADE_MODULE_SLOT = 1;
    private final LimaBlockEntityItemHandler inventory;
    private ItemStack previewItem = ItemStack.EMPTY;

    public EquipmentUpgradeStationBlockEntity(BlockPos pos, BlockState state) {
        super((LimaBlockEntityType)LTXIBlockEntities.EQUIPMENT_UPGRADE_STATION.get(), pos, state);
        this.inventory = new LimaBlockEntityItemHandler((ItemHolderBlockEntity)this, 2, BlockContentsType.GENERAL);
    }

    public ItemStack getPreviewItem() {
        return this.previewItem;
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(AutomaticDataWatcher.keepItemSynced(() -> this.inventory.getStackInSlot(0), stack -> {
            this.previewItem = stack;
        }));
    }

    @Nullable
    public LimaBlockEntityItemHandler getItemHandler(BlockContentsType contentsType) {
        return contentsType == BlockContentsType.GENERAL ? this.inventory : null;
    }

    public boolean isItemValid(BlockContentsType contentsType, int slot, ItemStack stack) {
        if (contentsType == BlockContentsType.GENERAL) {
            if (slot == 0) {
                return stack.getItem() instanceof UpgradableEquipmentItem;
            }
            return stack.getItem() instanceof EquipmentUpgradeModuleItem;
        }
        return true;
    }

    public IOAccess getSideIOForItems(@Nullable Direction side) {
        return IOAccess.DISABLED;
    }

    @Nullable
    public IItemHandler createItemIOWrapper(@Nullable Direction side) {
        return null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("items"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("items", (Tag)this.inventory.serializeNBT(registries));
    }
}

