/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.limacore.recipe.LimaRecipeInput;
import liedge.ltxindustries.blockentity.BaseFabricatorBlockEntity;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FabricatorBlockEntity
extends BaseFabricatorBlockEntity {
    public FabricatorBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.FABRICATOR.get()), pos, state, 0);
    }

    public void startCrafting(Level level, RecipeHolder<FabricatingRecipe> holder, LimaRecipeInput input, boolean forceStart) {
        FabricatingRecipe recipe = (FabricatingRecipe)holder.value();
        if (!this.isCrafting() && this.canInsertRecipeResults(level, recipe)) {
            if (forceStart) {
                this.setCrafting(true);
                this.getRecipeCheck().setLastUsedRecipe(holder);
            } else if (recipe.matches(input, level)) {
                recipe.consumeItemIngredients(input, level.getRandom());
                this.setCrafting(true);
                this.getRecipeCheck().setLastUsedRecipe(holder);
            }
        }
    }

    private void stopCrafting(boolean insertResult, ServerLevel level) {
        this.getRecipeCheck().getLastUsedRecipe((Level)level).ifPresent(holder -> {
            if (insertResult) {
                this.getOutputInventory().insertItem(0, ((FabricatingRecipe)holder.value()).generateItemResult(level), false);
            }
            this.energyCraftProgress = 0;
            this.setCrafting(false);
        });
    }

    @Override
    protected void tickServerFabricator(ServerLevel level, BlockPos pos, BlockState state) {
        FabricatingRecipe recipe = this.getRecipeCheck().getLastUsedRecipe((Level)level).map(RecipeHolder::value).orElse(null);
        if (this.isCrafting() && recipe != null) {
            if (this.energyCraftProgress < recipe.getEnergyRequired()) {
                int toExtract = Math.min(this.getEnergyUsage(), recipe.getEnergyRequired() - this.energyCraftProgress);
                this.energyCraftProgress += this.getEnergyStorage().extractEnergy(toExtract, false);
            } else {
                this.stopCrafting(true, level);
            }
        } else {
            this.stopCrafting(false, level);
        }
    }

    @Override
    public Item getValidBlueprintItem() {
        return (Item)LTXIItems.EMPTY_FABRICATION_BLUEPRINT.get();
    }
}

