/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.block.mesh.BlockMesh;
import liedge.ltxindustries.block.mesh.LTXIBlockMeshes;
import liedge.ltxindustries.block.mesh.MeshPosition;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public final class MeshBlockEntity
extends LimaBlockEntity {
    @Nullable
    private ResourceLocation meshId;
    @Nullable
    private BlockMesh blockMesh;
    private int meshIndex = -1;
    @Nullable
    private MeshPosition meshPosition;
    @Nullable
    private BlockPos primaryPos;

    public MeshBlockEntity(BlockPos pos, BlockState state) {
        super((LimaBlockEntityType)LTXIBlockEntities.MESH_BLOCK.get(), pos, state);
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
    }

    @Nullable
    public BlockMesh getBlockMesh() {
        if (this.blockMesh == null && this.meshId != null) {
            this.blockMesh = LTXIBlockMeshes.getBlockMesh(this.meshId);
        }
        return this.blockMesh;
    }

    public void setBlockMesh(BlockMesh blockMesh) {
        this.blockMesh = blockMesh;
        this.meshId = LTXIBlockMeshes.getBlockMeshId(blockMesh);
    }

    @Nullable
    public MeshPosition getMeshPosition() {
        BlockMesh mesh;
        if (this.meshPosition == null && this.meshIndex != -1 && (mesh = this.getBlockMesh()) != null) {
            this.meshPosition = mesh.getMeshPosition(this.meshIndex);
        }
        return this.meshPosition;
    }

    public void setMeshPosition(MeshPosition meshPosition) {
        this.meshPosition = meshPosition;
        this.meshIndex = meshPosition.index();
    }

    @Nullable
    public BlockPos getPrimaryPos(BlockPos pos, BlockState state) {
        if (this.primaryPos == null) {
            BlockMesh mesh = this.getBlockMesh();
            MeshPosition meshPosition = this.getMeshPosition();
            if (mesh != null && meshPosition != null) {
                Direction zAxis = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
                this.primaryPos = mesh.getPrimaryBlockPos(pos, meshPosition, zAxis);
            }
        }
        return this.primaryPos;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveMesh(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadMesh(tag);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadMesh(tag);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveMesh(tag);
    }

    private void loadMesh(CompoundTag tag) {
        this.meshId = LimaNbtUtil.getOptionalResourceLocation((CompoundTag)tag, (String)"mesh");
        this.meshIndex = LimaNbtUtil.getAsInt((CompoundTag)tag, (String)"index", (int)-1);
    }

    private void saveMesh(CompoundTag tag) {
        LimaNbtUtil.putOptionalResourceLocation((CompoundTag)tag, (String)"mesh", (ResourceLocation)this.meshId);
        tag.putInt("index", this.meshIndex);
    }
}

