/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.ltxindustries.block.LTXIBlockProperties;
import liedge.ltxindustries.block.MachineState;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.LTXIRecipeMachineBlockEntity;
import liedge.ltxindustries.recipe.MixingRecipe;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MixerBlockEntity
extends LTXIRecipeMachineBlockEntity.StateMachine<MixingRecipe> {
    private int spinSpeed = 0;
    private float impellerYRot0;
    private float impellerYRot;

    public MixerBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.MIXER.get()), (RecipeType)LTXIRecipeTypes.MIXING.get(), pos, state, 4, 1, 2, 1);
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.MIXER_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public int getBaseEnergyUsage() {
        return LTXIMachinesConfig.MIXER_ENERGY_USAGE.getAsInt();
    }

    protected void tickClient(Level level, BlockPos pos, BlockState state) {
        if (((MachineState)((Object)state.getValue(LTXIBlockProperties.BINARY_MACHINE_STATE))).isActive()) {
            if (this.spinSpeed < 40) {
                this.spinSpeed += 4;
            }
            this.impellerYRot0 = this.impellerYRot;
            this.impellerYRot = (this.impellerYRot + (float)this.spinSpeed) % 360.0f;
        } else if (this.spinSpeed > 5) {
            --this.spinSpeed;
            this.impellerYRot0 = this.impellerYRot;
            this.impellerYRot = (this.impellerYRot + (float)this.spinSpeed) % 360.0f;
        } else {
            this.spinSpeed = 0;
            this.impellerYRot0 = this.impellerYRot;
            if (this.impellerYRot % 90.0f != 0.0f) {
                int n = 90 * Mth.ceil((float)(this.impellerYRot / 90.0f));
                this.impellerYRot = Mth.approachDegrees((float)this.impellerYRot, (float)n, (float)5.0f);
            }
        }
    }

    public float lerpImpellerYRot(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.impellerYRot0, (float)this.impellerYRot);
    }
}

