/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.EnergyConsumerBlockEntity;
import liedge.ltxindustries.blockentity.base.FixedTimedProcessBlockEntity;
import liedge.ltxindustries.blockentity.template.ProductionMachineBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.util.LTXITooltipUtil;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public class MolecularReconstructorBlockEntity
extends ProductionMachineBlockEntity
implements EnergyConsumerBlockEntity,
FixedTimedProcessBlockEntity {
    private int energyUsage = this.getBaseEnergyUsage();
    private int machineSpeed = this.getBaseTicksPerOperation();
    private int currentProcessTime;

    public MolecularReconstructorBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.MOLECULAR_RECONSTRUCTOR.get()), pos, state, 2, 1, 1);
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.REPAIRER_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public int getBaseEnergyUsage() {
        return LTXIMachinesConfig.REPAIRER_ENERGY_USAGE.getAsInt();
    }

    @Override
    public int getEnergyUsage() {
        return this.energyUsage;
    }

    @Override
    public void setEnergyUsage(int energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    protected boolean isItemValidForInputInventory(int slot, ItemStack stack) {
        return stack.isDamageableItem() && !stack.is(LTXITags.Items.REPAIR_BLACKLIST);
    }

    @Override
    public void appendStatsTooltips(TooltipLineConsumer consumer) {
        consumer.accept((FormattedText)LTXILangKeys.MACHINE_TICKS_PER_OP_TOOLTIP.translateArgs(new Object[]{this.getTicksPerOperation()}));
        LTXITooltipUtil.appendEnergyUsagePerTickTooltip(consumer, this.getEnergyUsage());
    }

    protected void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        LimaBlockEntityItemHandler inputInventory = this.getInputInventory();
        LimaBlockEntityItemHandler outputInventory = this.getOutputInventory();
        this.fillEnergyBuffer();
        ItemStack inputItem = inputInventory.getStackInSlot(0);
        if (inputItem.isDamaged() && !inputItem.is(LTXITags.Items.REPAIR_BLACKLIST)) {
            if (LimaEnergyUtil.consumeEnergy((IEnergyStorage)this.getEnergyStorage(), (int)this.getEnergyUsage(), (boolean)false)) {
                ++this.currentProcessTime;
                if (this.currentProcessTime >= this.getTicksPerOperation()) {
                    ItemStack stack = inputItem.copy();
                    int oldDamage = (Integer)stack.getOrDefault(DataComponents.DAMAGE, (Object)0);
                    int newDamage = Math.max(0, oldDamage - 1);
                    stack.set(DataComponents.DAMAGE, (Object)newDamage);
                    inputInventory.setStackInSlot(0, stack);
                    this.currentProcessTime = 0;
                }
            }
        } else {
            this.currentProcessTime = 0;
            if (!inputItem.isEmpty() && outputInventory.getStackInSlot(0).isEmpty()) {
                ItemStack extracted = inputInventory.extractItem(0, outputInventory.getSlotLimit(0), false);
                outputInventory.insertItem(0, extracted, false);
            }
        }
        this.autoOutputItems(40, (IItemHandler)outputInventory);
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
    }

    @Override
    public int getCurrentProcessTime() {
        return this.currentProcessTime;
    }

    @Override
    public void setCurrentProcessTime(int currentProcessTime) {
        this.currentProcessTime = currentProcessTime;
    }

    @Override
    public int getBaseTicksPerOperation() {
        return LTXIMachinesConfig.REPAIRER_OPERATION_TIME.getAsInt();
    }

    @Override
    public int getTicksPerOperation() {
        return this.machineSpeed;
    }

    @Override
    public void setTicksPerOperation(int ticksPerOperation) {
        this.machineSpeed = ticksPerOperation;
    }

    @Override
    public void onUpgradeRefresh(LootContext context, MachineUpgrades upgrades) {
        super.onUpgradeRefresh(context, upgrades);
        FixedTimedProcessBlockEntity.applyUpgrades(this, context, upgrades);
        EnergyConsumerBlockEntity.applyUpgrades(this, context, upgrades);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("progress", this.currentProcessTime);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.currentProcessTime = tag.getInt("progress");
    }
}

