/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.util.LimaNetworkUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.blockentity.BaseTurretBlockEntity;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.entity.damage.TurretDamageSource;
import liedge.ltxindustries.lib.TurretTargetList;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RailgunTurretBlockEntity
extends BaseTurretBlockEntity {
    public RailgunTurretBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.RAILGUN_TURRET.get()), pos, state, 1.75, 25.0, 25.0, 25.0);
    }

    @Override
    protected int getEnergyPerTarget() {
        return LTXIMachinesConfig.NOCTIS_TURRET_ENERGY_PER_TARGET.getAsInt();
    }

    @Override
    protected int getTargetScanTime() {
        return 80;
    }

    @Override
    protected int getMaxTargetsPerScan() {
        return 1;
    }

    @Override
    protected int getFiringSequenceDelay() {
        return 40;
    }

    @Override
    protected boolean isValidTarget(Entity entity) {
        return entity.getType().is(LTXITags.EntityTypes.HIGH_THREAT_TARGETS);
    }

    @Override
    protected void serverTargetFiringTick(ServerLevel level, BlockPos pos, BlockState state, @Nullable Player owner, Entity target, TurretTargetList targetList) {
        if (this.ticker >= 10) {
            Vec3 start = this.getProjectileStart();
            float baseDamage = (float)LTXIMachinesConfig.NOCTIS_TURRET_DAMAGE.getAsDouble();
            LTXIEntityUtil.hurtWithEnchantedFakePlayer(level, target, (LivingEntity)owner, this.getUpgrades(), ignored -> TurretDamageSource.create((Level)level, LTXIDamageTypes.RAILGUN_TURRET, this, null, (Entity)owner, start), baseDamage);
            LimaNetworkUtil.sendParticle((Level)level, (ParticleOptions)new ColorParticleOptions(LTXIParticles.RAILGUN_BOLT, LTXIConstants.LIME_GREEN), (double)100.0, (Vec3)start, (Vec3)target.getBoundingBox().getCenter());
            level.playSound(null, start.x, start.y, start.z, (SoundEvent)LTXISounds.RAILGUN_BOOM.get(), SoundSource.BLOCKS, 2.5f, Mth.randomBetween((RandomSource)level.random, (float)0.85f, (float)0.95f));
            targetList.removeTarget(target);
            this.currentTarget = null;
            this.ticker = 0;
        }
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.NOCTIS_TURRET_ENERGY_CAPACITY.getAsInt();
    }
}

