/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity;

import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.blockentity.BaseTurretBlockEntity;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.entity.TurretRocketEntity;
import liedge.ltxindustries.lib.TurretTargetList;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RocketTurretBlockEntity
extends BaseTurretBlockEntity {
    public RocketTurretBlockEntity(BlockPos pos, BlockState state) {
        super((ConfigurableIOBlockEntityType)((Object)LTXIBlockEntities.ROCKET_TURRET.get()), pos, state, 1.625, 50.0, 20.0, 70.0);
    }

    @Override
    protected int getEnergyPerTarget() {
        return LTXIMachinesConfig.ATMOS_TURRET_ENERGY_PER_TARGET.getAsInt();
    }

    @Override
    protected int getTargetScanTime() {
        return 100;
    }

    @Override
    protected int getMaxTargetsPerScan() {
        return 4;
    }

    @Override
    protected int getFiringSequenceDelay() {
        return 40;
    }

    @Override
    protected boolean isValidTarget(Entity entity) {
        return entity.getType().is(LTXITags.EntityTypes.FLYING_TARGETS);
    }

    @Override
    protected void serverTargetFiringTick(ServerLevel level, BlockPos pos, BlockState state, @Nullable Player owner, Entity target, TurretTargetList targetList) {
        if (this.ticker >= 5) {
            Vec3 start = this.getProjectileStart();
            TurretRocketEntity rocket = new TurretRocketEntity((Level)level, this);
            rocket.setOwner((LivingEntity)owner);
            rocket.setPos(start);
            rocket.aimTowardsEntity(target, 2.5, 0.0);
            rocket.setTargetEntity(target);
            level.addFreshEntity((Entity)rocket);
            level.playSound(null, start.x, start.y, start.z, (SoundEvent)LTXISounds.ROCKET_LAUNCHER_FIRE.get(), SoundSource.BLOCKS, 1.5f, Mth.randomBetween((RandomSource)level.random, (float)0.75f, (float)0.9f));
            targetList.removeTarget(target);
            this.currentTarget = null;
            this.ticker = 0;
        }
    }

    public int getBaseEnergyCapacity() {
        return LTXIMachinesConfig.ATMOS_TURRET_ENERGY_CAPACITY.getAsInt();
    }
}

