/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.base;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.RelativeHorizontalSide;
import liedge.limacore.lib.OrderedEnum;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.BlockIOMap;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.IOConfigurationRules;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public sealed interface BlockIOConfiguration
permits BlockIOMap {
    public static final Codec<BlockIOConfiguration> CODEC = BlockIOMap.CODEC.xmap(Function.identity(), o -> (BlockIOMap)o);
    public static final StreamCodec<FriendlyByteBuf, BlockIOConfiguration> STREAM_CODEC = BlockIOMap.STREAM_CODEC.map(Function.identity(), o -> (BlockIOMap)o);

    public static BlockIOConfiguration create(IOConfigurationRules rules) {
        EnumMap<RelativeHorizontalSide, IOAccess> map = new EnumMap<RelativeHorizontalSide, IOAccess>(RelativeHorizontalSide.class);
        for (RelativeHorizontalSide side : rules.validSides()) {
            map.put(side, rules.defaultIOAccess());
        }
        return new BlockIOMap(map, rules.defaultAutoInput(), rules.defaultAutoOutput());
    }

    public static BlockIOConfiguration create(ConfigurableIOBlockEntityType<?> type, BlockEntityInputType inputType) {
        return BlockIOConfiguration.create(type.getIOConfigRules(inputType));
    }

    public IOAccess getIOAccess(RelativeHorizontalSide var1);

    public IOAccess getIOAccess(Direction var1, Direction var2);

    public BlockIOConfiguration setIOAccess(RelativeHorizontalSide var1, IOAccess var2);

    default public BlockIOConfiguration cycleIOAccess(RelativeHorizontalSide side, IOConfigurationRules rules, boolean forward) {
        IOAccess current = this.getIOAccess(side);
        IOAccess next = forward ? (IOAccess)OrderedEnum.nextAvailable(rules.validIOAccesses(), (Enum)current) : (IOAccess)OrderedEnum.previousAvailable(rules.validIOAccesses(), (Enum)current);
        return this.setIOAccess(side, next);
    }

    public boolean autoInput();

    public boolean autoOutput();

    public BlockIOConfiguration toggleAutoInput();

    public BlockIOConfiguration toggleAutoOutput();

    public boolean isValidForRules(IOConfigurationRules var1);

    public void forEach(BiConsumer<RelativeHorizontalSide, IOAccess> var1);
}

