/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.RelativeHorizontalSide;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.blockentity.base.IOConfigurationRules;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

record BlockIOMap(Map<RelativeHorizontalSide, IOAccess> map, boolean autoInput, boolean autoOutput) implements BlockIOConfiguration
{
    static final Codec<BlockIOMap> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.unboundedMap((Codec)RelativeHorizontalSide.CODEC, (Codec)IOAccess.CODEC).fieldOf("sides").forGetter(BlockIOMap::map), (App)Codec.BOOL.fieldOf("auto_input").forGetter(BlockIOMap::autoInput), (App)Codec.BOOL.fieldOf("auto_output").forGetter(BlockIOMap::autoOutput)).apply((Applicative)instance, BlockIOMap::new));
    static final StreamCodec<FriendlyByteBuf, BlockIOMap> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(size -> new EnumMap(RelativeHorizontalSide.class), (StreamCodec)RelativeHorizontalSide.STREAM_CODEC, (StreamCodec)IOAccess.STREAM_CODEC), blockIOMap -> blockIOMap.map, (StreamCodec)ByteBufCodecs.BOOL, BlockIOMap::autoInput, (StreamCodec)ByteBufCodecs.BOOL, BlockIOMap::autoOutput, BlockIOMap::new);

    static Map<RelativeHorizontalSide, IOAccess> copyOrCreateMap(Map<RelativeHorizontalSide, IOAccess> map) {
        return map.isEmpty() ? new EnumMap<RelativeHorizontalSide, IOAccess>(RelativeHorizontalSide.class) : new EnumMap<RelativeHorizontalSide, IOAccess>(map);
    }

    @Override
    public IOAccess getIOAccess(RelativeHorizontalSide side) {
        return this.map.getOrDefault(side, IOAccess.DISABLED);
    }

    @Override
    public IOAccess getIOAccess(Direction facing, Direction absoluteSide) {
        return this.getIOAccess(RelativeHorizontalSide.of((Direction)facing, (Direction)absoluteSide));
    }

    @Override
    public BlockIOConfiguration setIOAccess(RelativeHorizontalSide side, IOAccess access) {
        IOAccess current = this.getIOAccess(side);
        if (current == access) {
            return this;
        }
        Map<RelativeHorizontalSide, IOAccess> newMap = BlockIOMap.copyOrCreateMap(this.map);
        newMap.put(side, access);
        return new BlockIOMap(newMap, this.autoInput, this.autoOutput);
    }

    @Override
    public BlockIOConfiguration toggleAutoInput() {
        return new BlockIOMap(this.map, !this.autoInput, this.autoOutput);
    }

    @Override
    public BlockIOConfiguration toggleAutoOutput() {
        return new BlockIOMap(this.map, this.autoInput, !this.autoOutput);
    }

    @Override
    public boolean isValidForRules(IOConfigurationRules rules) {
        boolean mapTest = this.map.entrySet().stream().allMatch(entry -> rules.validSides().contains(entry.getKey()) && rules.validIOAccesses().contains(entry.getValue()));
        boolean autoIOTest = !(this.autoInput && !rules.allowsAutoInput() || this.autoOutput && !rules.allowsAutoOutput());
        return mapTest && autoIOTest;
    }

    @Override
    public void forEach(BiConsumer<RelativeHorizontalSide, IOAccess> consumer) {
        for (Map.Entry<RelativeHorizontalSide, IOAccess> entry : this.map.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }
}

