/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.base;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.IOConfigurationRules;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public final class ConfigurableIOBlockEntityType<BE extends LimaBlockEntity>
extends LimaBlockEntityType<BE> {
    private final Map<BlockEntityInputType, IOConfigurationRules> configRules;
    private final Set<BlockEntityInputType> validInputTypes;

    public static <BE extends LimaBlockEntity> Builder<BE> sidedBuilder(BlockEntityType.BlockEntitySupplier<BE> factory) {
        return new Builder<BE>(factory);
    }

    private ConfigurableIOBlockEntityType(BlockEntityType.BlockEntitySupplier<BE> factory, Set<Block> validBlocks, Map<BlockEntityInputType, IOConfigurationRules> configRules, @Nullable Holder<MenuType<?>> menuTypeHolder) {
        super(factory, validBlocks, menuTypeHolder);
        this.configRules = configRules;
        this.validInputTypes = Collections.unmodifiableSet(configRules.keySet());
    }

    public Collection<BlockEntityInputType> getValidInputTypes() {
        return this.validInputTypes;
    }

    public IOConfigurationRules getIOConfigRules(BlockEntityInputType inputType) {
        IOConfigurationRules rules = this.configRules.get((Object)inputType);
        if (rules != null) {
            return rules;
        }
        throw new IllegalArgumentException(String.format("Block entity type %s does not support input type %s", LimaRegistryUtil.getNonNullRegistryId((Object)((Object)this), (Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE), inputType.getSerializedName()));
    }

    public static class Builder<BE extends LimaBlockEntity>
    extends LimaBlockEntityType.AbstractBuilder<BE, ConfigurableIOBlockEntityType<BE>, Builder<BE>> {
        private final Map<BlockEntityInputType, IOConfigurationRules> ruleMap = new EnumMap<BlockEntityInputType, IOConfigurationRules>(BlockEntityInputType.class);

        private Builder(BlockEntityType.BlockEntitySupplier<BE> factory) {
            super(factory);
        }

        public Builder<BE> withConfigRules(BlockEntityInputType inputType, IOConfigurationRules rules) {
            LimaCollectionsUtil.putNoDuplicates(this.ruleMap, (Object)((Object)inputType), (Object)rules);
            return this;
        }

        public Builder<BE> withConfigRules(BlockEntityInputType inputType, UnaryOperator<IOConfigurationRules.Builder> builder) {
            return this.withConfigRules(inputType, ((IOConfigurationRules.Builder)builder.apply(IOConfigurationRules.builder())).build());
        }

        public ConfigurableIOBlockEntityType<BE> build() {
            return new ConfigurableIOBlockEntityType(this.factory, this.getValidBlocks(), (Map<BlockEntityInputType, IOConfigurationRules>)ImmutableMap.copyOf(this.ruleMap), this.menuTypeHolder);
        }
    }
}

