/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.RelativeHorizontalSide;

public record IOConfigurationRules(Set<RelativeHorizontalSide> validSides, Set<IOAccess> validIOAccesses, IOAccess defaultIOAccess, boolean allowsAutoInput, boolean allowsAutoOutput, boolean defaultAutoInput, boolean defaultAutoOutput) {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Set<RelativeHorizontalSide> ALL_SIDES = ImmutableSet.copyOf(EnumSet.allOf(RelativeHorizontalSide.class));
        private Set<RelativeHorizontalSide> validSides;
        private Set<IOAccess> validIOAccesses;
        private IOAccess defaultIOAccess = IOAccess.DISABLED;
        private boolean allowAutoInput;
        private boolean allowAutoOutput;
        private boolean defaultAutoInput;
        private boolean defaultAutoOutput;

        private Builder() {
        }

        public Builder forSides(Collection<RelativeHorizontalSide> sides) {
            Preconditions.checkArgument((!sides.isEmpty() ? 1 : 0) != 0, (Object)"Valid sides cannot be empty.");
            this.validSides = this.cloneIfNecessary(sides);
            return this;
        }

        public Builder forSides(RelativeHorizontalSide ... sides) {
            return this.forSides(List.of(sides));
        }

        public Builder forAllSides() {
            return this.forSides(ALL_SIDES);
        }

        public Builder permits(Collection<IOAccess> accesses) {
            Preconditions.checkArgument((!accesses.isEmpty() ? 1 : 0) != 0, (Object)"Valid IO access levels cannot be empty.");
            this.validIOAccesses = this.cloneIfNecessary(accesses);
            return this;
        }

        public Builder permits(IOAccess ... accesses) {
            return this.permits(List.of(accesses));
        }

        public Builder withDefaultIOAccess(IOAccess defaultIOAccess) {
            this.defaultIOAccess = defaultIOAccess;
            return this;
        }

        public Builder allowsAutoInput() {
            this.allowAutoInput = true;
            return this;
        }

        public Builder allowsAutoOutput() {
            this.allowAutoOutput = true;
            return this;
        }

        public Builder autoInputByDefault() {
            this.defaultAutoInput = true;
            return this.allowsAutoInput();
        }

        public Builder autoOutputByDefault() {
            this.defaultAutoOutput = true;
            return this.allowsAutoOutput();
        }

        public IOConfigurationRules build() {
            Objects.requireNonNull(this.validSides, "Valid sides not defined.");
            Objects.requireNonNull(this.validIOAccesses, "Valid IO accesses not defined.");
            Preconditions.checkState((boolean)this.validIOAccesses.contains(this.defaultIOAccess), (Object)"Default IO access not contained within valid accesses.");
            Preconditions.checkState((!this.allowAutoInput || this.validIOAccesses.stream().anyMatch(IOAccess::allowsInput) ? 1 : 0) != 0, (Object)"Auto input is enabled but no valid IO access permits input.");
            Preconditions.checkState((!this.allowAutoOutput || this.validIOAccesses.stream().anyMatch(IOAccess::allowsOutput) ? 1 : 0) != 0, (Object)"Auto output is enabled but no valid access permits output.");
            return new IOConfigurationRules(this.validSides, this.validIOAccesses, this.defaultIOAccess, this.allowAutoInput, this.allowAutoOutput, this.defaultAutoInput, this.defaultAutoOutput);
        }

        private <E extends Enum<E>> Set<E> cloneIfNecessary(Collection<E> collection) {
            if (collection instanceof ImmutableSet || collection instanceof ObjectSets.UnmodifiableSet) {
                return (Set)collection;
            }
            return ImmutableSet.copyOf(EnumSet.copyOf(collection));
        }
    }
}

