/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.base;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.capability.energy.EnergyHolderBlockEntity;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.blockentity.base.SubMenuProviderBlockEntity;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public interface UpgradesHolderBlockEntity
extends SubMenuProviderBlockEntity,
ItemHolderBlockEntity {
    public static final String TAG_KEY_UPGRADES = "upgrades";

    public MachineUpgrades getUpgrades();

    public void setUpgrades(MachineUpgrades var1);

    default public boolean hasStatsTooltips() {
        return true;
    }

    default public void appendStatsTooltips(TooltipLineConsumer consumer) {
    }

    default public LootContext createUpgradeContext(ServerLevel level) {
        LimaBlockEntity self = this.getAsLimaBlockEntity();
        LootParams params = new LootParams.Builder(level).withParameter(LootContextParams.BLOCK_STATE, (Object)self.getBlockState()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)self.getBlockPos())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)self).create(LootContextParamSets.BLOCK);
        return new LootContext.Builder(params).create(Optional.empty());
    }

    default public void onUpgradeRefresh(LootContext context, MachineUpgrades upgrades) {
        UpgradesHolderBlockEntity upgradesHolderBlockEntity = this;
        if (upgradesHolderBlockEntity instanceof EnergyHolderBlockEntity) {
            EnergyHolderBlockEntity energyHolder = (EnergyHolderBlockEntity)upgradesHolderBlockEntity;
            double newCapacity = upgrades.applyValue((Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.ENERGY_CAPACITY, context, (double)energyHolder.getBaseEnergyCapacity());
            double newTransferRate = upgrades.applyValue((Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, context, (double)energyHolder.getBaseEnergyTransferRate());
            energyHolder.getEnergyStorage().setMaxEnergyStored(LimaCoreMath.round((double)newCapacity));
            energyHolder.getEnergyStorage().setTransferRate(LimaCoreMath.round((double)newTransferRate));
        }
    }
}

