/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.template;

import java.util.Optional;
import java.util.function.IntUnaryOperator;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.capability.energy.LimaEnergyStorage;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.recipe.LimaRecipeCheck;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.EnergyConsumerBlockEntity;
import liedge.ltxindustries.blockentity.base.RecipeMachineBlockEntity;
import liedge.ltxindustries.blockentity.base.VariableTimedProcessBlockEntity;
import liedge.ltxindustries.blockentity.template.ProductionMachineBlockEntity;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class BaseRecipeMachineBlockEntity<I extends RecipeInput, R extends Recipe<I>>
extends ProductionMachineBlockEntity
implements VariableTimedProcessBlockEntity,
EnergyConsumerBlockEntity,
RecipeMachineBlockEntity<I, R> {
    private final LimaRecipeCheck<I, R> recipeCheck;
    private int energyUsage = this.getBaseEnergyUsage();
    private IntUnaryOperator recipeTimeFunction = IntUnaryOperator.identity();
    private int recipeCraftingTime;
    private int craftingProgress;
    private boolean crafting;
    private boolean shouldCheckRecipe;
    private boolean shouldCheckCraftingTime;

    protected BaseRecipeMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, RecipeType<R> recipeType, BlockPos pos, BlockState state, int inputSlots, int outputSlots, int inputTanks, int outputTanks) {
        super(type, pos, state, 2, inputSlots, outputSlots, inputTanks, outputTanks);
        this.recipeCheck = LimaRecipeCheck.create(recipeType);
    }

    @Override
    public int getEnergyUsage() {
        return this.energyUsage;
    }

    @Override
    public void setEnergyUsage(int energyUsage) {
        this.energyUsage = energyUsage;
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
    }

    @Override
    public int getCurrentProcessTime() {
        return this.craftingProgress;
    }

    @Override
    public void setCurrentProcessTime(int currentProcessTime) {
        this.craftingProgress = currentProcessTime;
    }

    @Override
    public int getTicksPerOperation() {
        return this.recipeCraftingTime;
    }

    @Override
    public void setTicksPerOperation(int ticksPerOperation) {
        this.recipeCraftingTime = ticksPerOperation;
    }

    @Override
    public void appendStatsTooltips(TooltipLineConsumer consumer) {
        LTXITooltipUtil.appendEnergyUsagePerTickTooltip(consumer, this.getEnergyUsage());
    }

    @Override
    public LimaRecipeCheck<I, R> getRecipeCheck() {
        return this.recipeCheck;
    }

    @Override
    public boolean isCrafting() {
        return this.crafting;
    }

    @Override
    public void setCrafting(boolean crafting) {
        if (this.crafting != crafting) {
            this.crafting = crafting;
            this.setChanged();
            this.onCraftingStateChanged(crafting);
        }
    }

    protected abstract void onCraftingStateChanged(boolean var1);

    protected abstract I getRecipeInput(Level var1);

    protected abstract int getBaseRecipeCraftingTime(R var1);

    protected abstract void consumeIngredients(I var1, R var2, Level var3);

    protected abstract void insertRecipeResults(Level var1, R var2, I var3);

    protected void reCheckRecipe() {
        this.shouldCheckRecipe = true;
    }

    public void onEnergyChanged(int previousEnergy) {
        this.setChanged();
        if (previousEnergy < this.getEnergyUsage() && this.getEnergyStorage().getEnergyStored() >= this.getEnergyUsage()) {
            this.reCheckRecipe();
        }
    }

    public void onItemSlotChanged(BlockContentsType contentsType, int slot) {
        this.setChanged();
        if (contentsType == BlockContentsType.INPUT || contentsType == BlockContentsType.OUTPUT && !this.crafting) {
            this.reCheckRecipe();
        }
    }

    @Override
    public void onFluidsChanged(BlockContentsType contentsType, int tank) {
        super.onFluidsChanged(contentsType, tank);
        if (contentsType == BlockContentsType.INPUT || contentsType == BlockContentsType.OUTPUT && !this.crafting) {
            this.reCheckRecipe();
        }
    }

    protected void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        LimaEnergyStorage energyStorage = this.getEnergyStorage();
        this.fillEnergyBuffer();
        if (this.shouldCheckRecipe) {
            Optional lastUsed = this.recipeCheck.getLastUsedRecipe((Level)level);
            Optional lookup = this.recipeCheck.getRecipeFor(this.getRecipeInput((Level)level), (Level)level);
            boolean hasValidRecipe = false;
            if (lookup.isPresent()) {
                RecipeHolder recipeHolder = (RecipeHolder)lookup.get();
                boolean recipeChanged = lastUsed.filter(arg_0 -> ((RecipeHolder)recipeHolder).equals(arg_0)).isEmpty();
                if (recipeChanged) {
                    this.shouldCheckCraftingTime = true;
                }
                if ((hasValidRecipe = this.canInsertRecipeResults((Level)level, recipeHolder)) && this.shouldCheckCraftingTime) {
                    int baseTime = this.getBaseRecipeCraftingTime(recipeHolder.value());
                    int time = this.recipeTimeFunction.applyAsInt(baseTime);
                    this.setTicksPerOperation(time);
                    this.shouldCheckCraftingTime = false;
                }
            }
            if (!hasValidRecipe) {
                this.craftingProgress = 0;
            }
            this.shouldCheckRecipe = false;
            this.setCrafting(hasValidRecipe && energyStorage.getEnergyStored() >= this.getEnergyUsage());
        }
        RecipeHolder lastUsedRecipe = this.recipeCheck.getLastUsedRecipe((Level)level).orElse(null);
        if (this.crafting && lastUsedRecipe != null) {
            if (LimaEnergyUtil.consumeEnergy((IEnergyStorage)energyStorage, (int)this.getEnergyUsage(), (boolean)false)) {
                ++this.craftingProgress;
                if (this.craftingProgress >= this.getTicksPerOperation()) {
                    I recipeInput = this.getRecipeInput((Level)level);
                    this.insertRecipeResults((Level)level, lastUsedRecipe.value(), recipeInput);
                    this.consumeIngredients(recipeInput, lastUsedRecipe.value(), (Level)level);
                    this.craftingProgress = 0;
                    this.reCheckRecipe();
                }
            } else {
                this.setCrafting(false);
            }
        }
        this.autoOutputItems(20, (IItemHandler)this.getOutputInventory());
        this.autoOutputFluids(20);
    }

    @Override
    public void onUpgradeRefresh(LootContext context, MachineUpgrades upgrades) {
        super.onUpgradeRefresh(context, upgrades);
        EnergyConsumerBlockEntity.applyUpgrades(this, context, upgrades);
        this.recipeTimeFunction = BaseRecipeMachineBlockEntity.createCachedSpeedFunction(upgrades, context);
        this.shouldCheckCraftingTime = true;
        this.reCheckRecipe();
    }

    @Override
    protected void onLoadServer(ServerLevel level) {
        super.onLoadServer(level);
        this.reCheckRecipe();
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.craftingProgress = tag.getInt("progress");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("progress", this.craftingProgress);
    }
}

