/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.template;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import liedge.limacore.capability.energy.EnergyHolderBlockEntity;
import liedge.limacore.capability.energy.LimaBlockEntityEnergyStorage;
import liedge.limacore.capability.energy.LimaEnergyStorage;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.LTXIMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public abstract non-sealed class EnergyMachineBlockEntity
extends LTXIMachineBlockEntity
implements EnergyHolderBlockEntity {
    private final LimaEnergyStorage energyStorage;
    private BlockIOConfiguration energyIOConfig;

    protected EnergyMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, @Nullable LimaEnergyStorage energyStorage, int auxInventorySize) {
        super(type, pos, state, auxInventorySize);
        Preconditions.checkArgument((auxInventorySize > 1 ? 1 : 0) != 0, (Object)"Auxiliary inventory for powered machines must have at least 2 slots.");
        this.energyStorage = energyStorage != null ? energyStorage : new LimaBlockEntityEnergyStorage((EnergyHolderBlockEntity)this);
        this.energyIOConfig = BlockIOConfiguration.create(type, BlockEntityInputType.ENERGY);
    }

    protected EnergyMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, @Nullable LimaEnergyStorage energyStorage) {
        this(type, pos, state, energyStorage, 2);
    }

    protected void fillEnergyBuffer() {
        IEnergyStorage itemEnergy;
        LimaEnergyStorage energy = this.getEnergyStorage();
        if (energy.getEnergyStored() < energy.getMaxEnergyStored() && (itemEnergy = (IEnergyStorage)this.getAuxInventory().getStackInSlot(1).getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            LimaEnergyUtil.transferEnergyBetween((IEnergyStorage)itemEnergy, (IEnergyStorage)energy, (int)energy.getTransferRate(), (boolean)false);
        }
    }

    protected void autoOutputEnergy() {
        if (this.energyIOConfig.autoOutput()) {
            for (Direction side : Direction.values()) {
                if (!this.energyIOConfig.getIOAccess(this.getFacing(), side).allowsOutput()) continue;
                LimaEnergyStorage energy = this.getEnergyStorage();
                IEnergyStorage neighborEnergy = this.getNeighborEnergyStorage(side);
                if (neighborEnergy == null) continue;
                LimaEnergyUtil.transferEnergyBetween((IEnergyStorage)energy, (IEnergyStorage)neighborEnergy, (int)energy.getTransferRate(), (boolean)false);
            }
        }
    }

    @Override
    protected BlockIOConfiguration getEnergyIOConfiguration() {
        return this.energyIOConfig;
    }

    @Override
    protected void setEnergyIOConfiguration(BlockIOConfiguration configuration) {
        this.energyIOConfig = configuration;
    }

    public LimaEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getBaseEnergyTransferRate() {
        return this.getBaseEnergyCapacity() / 20;
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.getEnergyStorage().setEnergyStored(((Integer)componentInput.getOrDefault((Supplier)LimaCoreDataComponents.ENERGY, (Object)0)).intValue());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        LimaEnergyStorage limaEnergyStorage = this.getEnergyStorage();
        if (limaEnergyStorage instanceof LimaBlockEntityEnergyStorage) {
            LimaBlockEntityEnergyStorage blockEntityEnergy = (LimaBlockEntityEnergyStorage)limaEnergyStorage;
            blockEntityEnergy.writeComponents(components);
        }
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("energy");
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        LimaEnergyStorage limaEnergyStorage = this.getEnergyStorage();
        if (limaEnergyStorage instanceof LimaBlockEntityEnergyStorage) {
            LimaBlockEntityEnergyStorage blockEntityEnergy = (LimaBlockEntityEnergyStorage)limaEnergyStorage;
            LimaNbtUtil.deserializeInt((INBTSerializable)blockEntityEnergy, (HolderLookup.Provider)registries, (Tag)tag.get("energy"));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        LimaEnergyStorage limaEnergyStorage = this.getEnergyStorage();
        if (limaEnergyStorage instanceof LimaBlockEntityEnergyStorage) {
            LimaBlockEntityEnergyStorage blockEntityEnergy = (LimaBlockEntityEnergyStorage)limaEnergyStorage;
            tag.put("energy", (Tag)blockEntityEnergy.serializeNBT(registries));
        }
    }
}

