/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.template;

import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.capability.itemhandler.LimaItemHandlerUtil;
import liedge.limacore.util.LimaItemUtil;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntity;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.IOConfigurationRules;
import liedge.ltxindustries.blockentity.base.UpgradesHolderBlockEntity;
import liedge.ltxindustries.blockentity.template.EnergyMachineBlockEntity;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract sealed class LTXIMachineBlockEntity
extends LimaBlockEntity
implements ConfigurableIOBlockEntity,
UpgradesHolderBlockEntity
permits EnergyMachineBlockEntity {
    public static final int AUX_MODULE_ITEM_SLOT = 0;
    public static final int AUX_ENERGY_ITEM_SLOT = 1;
    private final ConfigurableIOBlockEntityType<?> type;
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> itemConnections = new EnumMap<Direction, BlockCapabilityCache<IItemHandler, Direction>>(Direction.class);
    private final LimaBlockEntityItemHandler auxInventory;
    private BlockIOConfiguration itemIOConfig;
    private MachineUpgrades upgrades = MachineUpgrades.EMPTY;
    private int autoItemOutputTimer;

    protected LTXIMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, int auxInventorySize) {
        super(type, pos, state);
        this.type = type;
        this.itemIOConfig = BlockIOConfiguration.create(type, BlockEntityInputType.ITEMS);
        this.auxInventory = new LimaBlockEntityItemHandler((ItemHolderBlockEntity)this, auxInventorySize, BlockContentsType.AUXILIARY);
    }

    public LimaBlockEntityItemHandler getAuxInventory() {
        return this.auxInventory;
    }

    @Override
    public final Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public Collection<BlockEntityInputType> getConfigurableInputTypes() {
        return this.type.getValidInputTypes();
    }

    @Override
    public IOConfigurationRules getIOConfigRules(BlockEntityInputType inputType) {
        return this.type.getIOConfigRules(inputType);
    }

    @Override
    @Nullable
    public final BlockIOConfiguration getIOConfiguration(BlockEntityInputType inputType) {
        return switch (inputType) {
            default -> throw new MatchException(null, null);
            case BlockEntityInputType.ITEMS -> this.getItemIOConfiguration();
            case BlockEntityInputType.ENERGY -> this.getEnergyIOConfiguration();
            case BlockEntityInputType.FLUIDS -> this.getFluidIOConfiguration();
        };
    }

    @Override
    public void setIOConfiguration(BlockEntityInputType inputType, BlockIOConfiguration configuration) {
        switch (inputType) {
            case ITEMS: {
                this.setItemIOConfiguration(configuration);
                break;
            }
            case ENERGY: {
                this.setEnergyIOConfiguration(configuration);
                break;
            }
            case FLUIDS: {
                this.setFluidIOConfiguration(configuration);
            }
        }
        if (this.level != null && !this.level.isClientSide()) {
            this.invalidateCapabilities();
            this.setChanged();
        }
    }

    public IOAccess getSideIOForItems(@Nullable Direction side) {
        return side != null ? this.itemIOConfig.getIOAccess(this.getFacing(), side) : IOAccess.DISABLED;
    }

    public IOAccess getSideIOForEnergy(@Nullable Direction side) {
        return side != null ? this.getIOConfigurationOrThrow(BlockEntityInputType.ENERGY).getIOAccess(this.getFacing(), side) : IOAccess.DISABLED;
    }

    public IOAccess getSideIOForFluids(@Nullable Direction side) {
        return side != null ? this.getIOConfigurationOrThrow(BlockEntityInputType.FLUIDS).getIOAccess(this.getFacing(), side) : IOAccess.DISABLED;
    }

    protected BlockIOConfiguration getItemIOConfiguration() {
        return this.itemIOConfig;
    }

    protected void setItemIOConfiguration(BlockIOConfiguration configuration) {
        this.itemIOConfig = configuration;
    }

    @Nullable
    protected BlockIOConfiguration getEnergyIOConfiguration() {
        return null;
    }

    protected void setEnergyIOConfiguration(BlockIOConfiguration configuration) {
    }

    @Nullable
    protected BlockIOConfiguration getFluidIOConfiguration() {
        return null;
    }

    protected void setFluidIOConfiguration(BlockIOConfiguration configuration) {
    }

    @Nullable
    public IItemHandler getNeighborItemHandler(Direction side) {
        return (IItemHandler)this.itemConnections.get(side).getCapability();
    }

    @Nullable
    public IEnergyStorage getNeighborEnergyStorage(Direction side) {
        return null;
    }

    @Nullable
    public IFluidHandler getNeighborFluidHandler(Direction side) {
        return null;
    }

    protected void createConnectionCaches(ServerLevel level, Direction side) {
        this.itemConnections.put(side, (BlockCapabilityCache<IItemHandler, Direction>)this.createCapabilityCache(Capabilities.ItemHandler.BLOCK, level, side));
    }

    @Override
    public MachineUpgrades getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void setUpgrades(MachineUpgrades upgrades) {
        this.upgrades = upgrades;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setChanged();
            this.onUpgradeRefresh(this.createUpgradeContext(serverLevel), upgrades);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        this.setUpgrades((MachineUpgrades)componentInput.getOrDefault(LTXIDataComponents.MACHINE_UPGRADES, (Object)MachineUpgrades.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(LTXIDataComponents.MACHINE_UPGRADES, (Object)this.getUpgrades());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("upgrades");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries);
        CompoundTag inventoriesTag = tag.getCompound("items");
        for (BlockContentsType type : BlockContentsType.values()) {
            LimaBlockEntityItemHandler handler = this.getItemHandler(type);
            if (handler == null || !inventoriesTag.contains(type.getSerializedName())) continue;
            handler.deserializeNBT(registries, inventoriesTag.getCompound(type.getSerializedName()));
        }
        this.upgrades = (MachineUpgrades)LimaNbtUtil.tryDecode(MachineUpgrades.CODEC, (DynamicOps)ops, (CompoundTag)tag, (String)"upgrades", (Object)MachineUpgrades.EMPTY);
        CompoundTag ioConfigsTag = tag.getCompound("io_configs");
        for (BlockEntityInputType inputType : this.getConfigurableInputTypes()) {
            BlockIOConfiguration config = (BlockIOConfiguration)LimaNbtUtil.tryDecode(BlockIOConfiguration.CODEC, (DynamicOps)ops, (CompoundTag)ioConfigsTag, (String)inputType.getSerializedName());
            if (config == null || !config.isValidForRules(this.type.getIOConfigRules(inputType))) continue;
            this.setIOConfiguration(inputType, config);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries);
        CompoundTag inventoriesTag = new CompoundTag();
        for (BlockContentsType type : BlockContentsType.values()) {
            LimaBlockEntityItemHandler handler = this.getItemHandler(type);
            if (handler == null) continue;
            inventoriesTag.put(type.getSerializedName(), (Tag)handler.serializeNBT(registries));
        }
        tag.put("items", (Tag)inventoriesTag);
        LimaNbtUtil.tryEncodeTo(MachineUpgrades.CODEC, (DynamicOps)ops, (Object)this.upgrades, (CompoundTag)tag, (String)"upgrades");
        CompoundTag ioConfigsTag = new CompoundTag();
        for (BlockEntityInputType inputType : this.getConfigurableInputTypes()) {
            BlockIOConfiguration configuration = this.getIOConfigurationOrThrow(inputType);
            LimaNbtUtil.tryEncodeTo(BlockIOConfiguration.CODEC, (DynamicOps)ops, (Object)configuration, (CompoundTag)ioConfigsTag, (String)inputType.getSerializedName());
        }
        tag.put("io_configs", (Tag)ioConfigsTag);
    }

    public boolean isItemValid(BlockContentsType contentsType, int slot, ItemStack stack) {
        return contentsType != BlockContentsType.AUXILIARY || this.isItemValidForAuxInventory(slot, stack);
    }

    protected boolean isItemValidForAuxInventory(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> stack.is(LTXIItems.MACHINE_UPGRADE_MODULE);
            case 1 -> LimaItemUtil.hasEnergyCapability((ItemStack)stack);
            default -> false;
        };
    }

    protected void autoOutputItems(IItemHandler internalInventory, Predicate<ItemStack> predicate) {
        if (this.itemIOConfig.autoOutput()) {
            for (Direction side : Direction.values()) {
                IItemHandler neighborInv;
                if (!this.itemIOConfig.getIOAccess(this.getFacing(), side).allowsOutput() || (neighborInv = this.getNeighborItemHandler(side)) == null) continue;
                LimaItemHandlerUtil.transferItemsBetween((IItemHandler)internalInventory, (IItemHandler)neighborInv, predicate);
            }
        }
    }

    protected void autoOutputItems(int frequency, IItemHandler internalInventory, Predicate<ItemStack> predicate) {
        if (this.autoItemOutputTimer >= frequency) {
            this.autoOutputItems(internalInventory, predicate);
            this.autoItemOutputTimer = 0;
        } else {
            ++this.autoItemOutputTimer;
        }
    }

    protected void autoOutputItems(int frequency, IItemHandler internalInventory) {
        this.autoOutputItems(frequency, internalInventory, LimaItemUtil.ALWAYS_TRUE);
    }

    protected void onLoadServer(ServerLevel level) {
        this.onUpgradeRefresh(this.createUpgradeContext(level), this.getUpgrades());
        for (Direction side : Direction.values()) {
            this.createConnectionCaches(level, side);
        }
    }
}

