/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.template;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.capability.fluid.LimaBlockEntityFluidHandler;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.recipe.result.ItemResult;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.block.LTXIBlockProperties;
import liedge.ltxindustries.block.MachineState;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.RecipeModeHolderBlockEntity;
import liedge.ltxindustries.blockentity.template.BaseRecipeMachineBlockEntity;
import liedge.ltxindustries.recipe.LTXIRecipe;
import liedge.ltxindustries.recipe.LTXIRecipeInput;
import liedge.ltxindustries.recipe.RecipeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class LTXIRecipeMachineBlockEntity<R extends LTXIRecipe>
extends BaseRecipeMachineBlockEntity<LTXIRecipeInput, R>
implements RecipeModeHolderBlockEntity {
    @Nullable
    private Holder<RecipeMode> mode;

    protected LTXIRecipeMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, RecipeType<R> recipeType, BlockPos pos, BlockState state, int inputSlots, int outputSlots, int inputTanks, int outputTanks) {
        super(type, recipeType, pos, state, inputSlots, outputSlots, inputTanks, outputTanks);
    }

    @Override
    @Nullable
    public Holder<RecipeMode> getMode() {
        return this.mode;
    }

    @Override
    public void setMode(@Nullable Holder<RecipeMode> mode) {
        this.mode = mode;
        if (this.checkServerSide()) {
            this.setChanged();
            this.reCheckRecipe();
        }
    }

    @Override
    public Holder<RecipeType<?>> getRecipeTypeHolder() {
        return BuiltInRegistries.RECIPE_TYPE.wrapAsHolder((Object)this.getRecipeCheck().getRecipeType());
    }

    @Override
    protected LTXIRecipeInput getRecipeInput(Level level) {
        return new LTXIRecipeInput((IItemHandler)this.getItemHandler(BlockContentsType.INPUT), (LimaFluidHandler)this.getFluidHandler(BlockContentsType.INPUT), this.mode);
    }

    @Override
    protected int getBaseRecipeCraftingTime(R recipe) {
        return ((LTXIRecipe)((Object)recipe)).getCraftTime();
    }

    @Override
    protected void consumeIngredients(LTXIRecipeInput recipeInput, R recipe, Level level) {
        recipe.consumeItemIngredients((LimaRecipeInput)recipeInput, level.getRandom());
        recipe.consumeFluidIngredients((LimaRecipeInput)recipeInput);
    }

    @Override
    public boolean canInsertRecipeResults(Level level, R recipe) {
        List itemResults = recipe.getItemResults();
        boolean itemCheck = switch (itemResults.size()) {
            case 0 -> true;
            case 1 -> ItemHandlerHelper.insertItem((IItemHandler)this.getOutputInventory(), (ItemStack)((ItemResult)itemResults.getFirst()).getMaximumResult(), (boolean)true).isEmpty();
            default -> {
                ItemStackHandler interim = this.getOutputInventory().copyHandler();
                for (ItemResult result : itemResults) {
                    ItemStack maxOutput = result.getMaximumResult();
                    if (!result.requiredOutput() || ItemHandlerHelper.insertItem((IItemHandler)interim, (ItemStack)maxOutput, (boolean)false).isEmpty()) continue;
                    yield false;
                }
                yield true;
            }
        };
        List fluidResults = recipe.getFluidResults();
        boolean fluidCheck = switch (fluidResults.size()) {
            case 0 -> true;
            case 1 -> {
                FluidStack first = (FluidStack)fluidResults.getFirst();
                if (this.getFluidHandlerOrThrow(BlockContentsType.OUTPUT).fillAny(first, IFluidHandler.FluidAction.SIMULATE, true) == first.getAmount()) {
                    yield true;
                }
                yield false;
            }
            default -> {
                LimaFluidHandler interim = this.getFluidHandlerOrThrow(BlockContentsType.OUTPUT).copyHandler();
                for (FluidStack stack : fluidResults) {
                    if (interim.fillAny(stack, IFluidHandler.FluidAction.EXECUTE, true) == stack.getAmount()) continue;
                    yield false;
                }
                yield true;
            }
        };
        return itemCheck && fluidCheck;
    }

    @Override
    protected void insertRecipeResults(Level level, R recipe, LTXIRecipeInput recipeInput) {
        List results = recipe.generateItemResults((LimaRecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess(), level.random);
        for (ItemStack stack : results) {
            ItemHandlerHelper.insertItem((IItemHandler)this.getOutputInventory(), (ItemStack)stack, (boolean)false);
        }
        LimaBlockEntityFluidHandler outputFluids = this.getFluidHandler(BlockContentsType.OUTPUT);
        if (outputFluids != null) {
            List fluidResults = recipe.generateFluidResults((LimaRecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess());
            for (FluidStack stack : fluidResults) {
                outputFluids.fillAny(stack, IFluidHandler.FluidAction.EXECUTE, true);
            }
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.mode = (Holder)LimaNbtUtil.tryDecode(RecipeMode.CODEC, (DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), (CompoundTag)tag, (String)"recipe_mode");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        LimaNbtUtil.tryEncodeTo(RecipeMode.CODEC, (DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), this.mode, (CompoundTag)tag, (String)"recipe_mode");
    }

    public static abstract class StateMachine<R extends LTXIRecipe>
    extends LTXIRecipeMachineBlockEntity<R> {
        protected StateMachine(ConfigurableIOBlockEntityType<?> type, RecipeType<R> recipeType, BlockPos pos, BlockState state, int inputSlots, int outputSlots, int inputTanks, int outputTanks) {
            super(type, recipeType, pos, state, inputSlots, outputSlots, inputTanks, outputTanks);
        }

        @Override
        protected void onCraftingStateChanged(boolean newCraftingState) {
            BlockState newState = (BlockState)this.getBlockState().setValue(LTXIBlockProperties.BINARY_MACHINE_STATE, (Comparable)((Object)MachineState.of(newCraftingState)));
            this.nonNullLevel().setBlockAndUpdate(this.getBlockPos(), newState);
        }
    }
}

