/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.blockentity.template;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.capability.fluid.FluidHolderBlockEntity;
import liedge.limacore.capability.fluid.LimaBlockEntityFluidHandler;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import liedge.limacore.capability.fluid.LimaFluidUtil;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.lib.math.MathOperation;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.template.EnergyMachineBlockEntity;
import liedge.ltxindustries.lib.upgrades.EffectRankPair;
import liedge.ltxindustries.lib.upgrades.effect.MinimumSpeedUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class ProductionMachineBlockEntity
extends EnergyMachineBlockEntity
implements FluidHolderBlockEntity {
    public static final int INPUT_TANK_CAPACITY = 32000;
    public static final int OUTPUT_TANK_CAPACITY = 64000;
    @Nullable
    private final LimaBlockEntityItemHandler inputInventory;
    @Nullable
    private final LimaBlockEntityItemHandler outputInventory;
    @Nullable
    private final LimaBlockEntityFluidHandler inputFluids;
    @Nullable
    private final LimaBlockEntityFluidHandler outputFluids;
    @Nullable
    private BlockIOConfiguration fluidsIOConfig;
    private final Map<Direction, BlockCapabilityCache<IFluidHandler, Direction>> fluidConnections = new EnumMap<Direction, BlockCapabilityCache<IFluidHandler, Direction>>(Direction.class);
    private int autoFluidOutputTimer = 0;

    protected ProductionMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, int auxInventorySize, int inputSlots, int outputSlots, int inputTanks, int outputTanks) {
        super(type, pos, state, null, auxInventorySize);
        this.inputInventory = inputSlots > 0 ? new LimaBlockEntityItemHandler((ItemHolderBlockEntity)this, inputSlots, BlockContentsType.INPUT) : null;
        this.outputInventory = outputSlots > 0 ? new LimaBlockEntityItemHandler((ItemHolderBlockEntity)this, outputSlots, BlockContentsType.OUTPUT) : null;
        this.inputFluids = inputTanks > 0 ? new LimaBlockEntityFluidHandler((FluidHolderBlockEntity)this, inputTanks, BlockContentsType.INPUT) : null;
        this.outputFluids = outputTanks > 0 ? new LimaBlockEntityFluidHandler((FluidHolderBlockEntity)this, outputTanks, BlockContentsType.OUTPUT) : null;
        this.fluidsIOConfig = this.inputFluids != null || this.outputFluids != null ? BlockIOConfiguration.create(type, BlockEntityInputType.FLUIDS) : null;
    }

    protected ProductionMachineBlockEntity(ConfigurableIOBlockEntityType<?> type, BlockPos pos, BlockState state, int auxInventorySize, int inputSlots, int outputSlots) {
        this(type, pos, state, auxInventorySize, inputSlots, outputSlots, 0, 0);
    }

    public LimaBlockEntityItemHandler getInputInventory() {
        return this.getItemHandlerOrThrow(BlockContentsType.INPUT);
    }

    public LimaBlockEntityItemHandler getOutputInventory() {
        return this.getItemHandlerOrThrow(BlockContentsType.OUTPUT);
    }

    @Override
    public boolean isItemValid(BlockContentsType contentsType, int slot, ItemStack stack) {
        if (contentsType == BlockContentsType.INPUT) {
            return this.isItemValidForInputInventory(slot, stack);
        }
        return super.isItemValid(contentsType, slot, stack);
    }

    protected boolean isItemValidForInputInventory(int slot, ItemStack stack) {
        return true;
    }

    @Nullable
    public LimaBlockEntityItemHandler getItemHandler(BlockContentsType contentsType) {
        return switch (contentsType) {
            default -> throw new MatchException(null, null);
            case BlockContentsType.GENERAL -> null;
            case BlockContentsType.AUXILIARY -> this.getAuxInventory();
            case BlockContentsType.INPUT -> this.inputInventory;
            case BlockContentsType.OUTPUT -> this.outputInventory;
        };
    }

    @Nullable
    public IItemHandler createItemIOWrapper(@Nullable Direction side) {
        return this.wrapInputOutputInventories(side);
    }

    @Nullable
    public LimaBlockEntityFluidHandler getFluidHandler(BlockContentsType contentsType) {
        return switch (contentsType) {
            case BlockContentsType.INPUT -> this.inputFluids;
            case BlockContentsType.OUTPUT -> this.outputFluids;
            default -> null;
        };
    }

    public int getBaseFluidCapacity(BlockContentsType contentsType, int tank) {
        return switch (contentsType) {
            case BlockContentsType.INPUT -> 32000;
            case BlockContentsType.OUTPUT -> 64000;
            default -> 0;
        };
    }

    public int getBaseFluidTransferRate(BlockContentsType contentsType, int tank) {
        return this.getBaseFluidCapacity(contentsType, tank) / 4;
    }

    public boolean isValidFluid(BlockContentsType contentsType, int tank, FluidStack stack) {
        return true;
    }

    @Nullable
    public IFluidHandler createFluidIOWrapper(@Nullable Direction side) {
        return this.wrapInputOutputTanks(side);
    }

    @Override
    @Nullable
    protected BlockIOConfiguration getFluidIOConfiguration() {
        return this.fluidsIOConfig;
    }

    @Override
    protected void setFluidIOConfiguration(BlockIOConfiguration configuration) {
        this.fluidsIOConfig = configuration;
    }

    public void onFluidsChanged(BlockContentsType contentsType, int tank) {
        this.setChanged();
    }

    @Override
    @Nullable
    public IFluidHandler getNeighborFluidHandler(Direction side) {
        return (IFluidHandler)this.fluidConnections.get(side).getCapability();
    }

    protected void autoOutputFluids() {
        if (this.outputFluids != null && this.fluidsIOConfig != null && this.fluidsIOConfig.autoOutput()) {
            for (Direction side : Direction.values()) {
                IFluidHandler neighborFluids;
                if (!this.fluidsIOConfig.getIOAccess(this.getFacing(), side).allowsOutput() || (neighborFluids = this.getNeighborFluidHandler(side)) == null) continue;
                LimaFluidUtil.transferFluidsFromLimaTank((LimaFluidHandler)this.outputFluids, (IFluidHandler)neighborFluids, (int)64000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    protected void autoOutputFluids(int frequency) {
        if (this.autoFluidOutputTimer >= frequency) {
            this.autoOutputFluids();
            this.autoFluidOutputTimer = 0;
        } else {
            ++this.autoFluidOutputTimer;
        }
    }

    @Override
    protected void createConnectionCaches(ServerLevel level, Direction side) {
        super.createConnectionCaches(level, side);
        if (this.inputFluids != null || this.outputFluids != null) {
            this.fluidConnections.put(side, (BlockCapabilityCache<IFluidHandler, Direction>)this.createCapabilityCache(Capabilities.FluidHandler.BLOCK, level, side));
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("fluid_tanks", 10)) {
            CompoundTag tanksTag = tag.getCompound("fluid_tanks");
            for (BlockContentsType type : BlockContentsType.values()) {
                LimaBlockEntityFluidHandler handler = this.getFluidHandler(type);
                if (handler == null || !tanksTag.contains(type.getSerializedName())) continue;
                handler.deserializeNBT(registries, tanksTag.getList(type.getSerializedName(), 10));
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        CompoundTag tanksTag = new CompoundTag();
        for (BlockContentsType type : BlockContentsType.values()) {
            LimaBlockEntityFluidHandler handler = this.getFluidHandler(type);
            if (handler == null) continue;
            tanksTag.put(type.getSerializedName(), (Tag)handler.serializeNBT(registries));
        }
        if (!tanksTag.isEmpty()) {
            tag.put("fluid_tanks", (Tag)tanksTag);
        }
    }

    protected static IntUnaryOperator createCachedSpeedFunction(MachineUpgrades upgrades, LootContext context) {
        int minSpeed = upgrades.effectStream(LTXIUpgradeEffectComponents.MINIMUM_MACHINE_SPEED).mapToInt(MinimumSpeedUpgradeEffect::minimumSpeed).min().orElse(0);
        List list = upgrades.boxedFlatStream(LTXIUpgradeEffectComponents.TICKS_PER_OPERATION).sorted(MathOperation.comparingPriority(o -> ((ValueUpgradeEffect)o.effect()).operation())).toList();
        if (list.isEmpty()) {
            return IntUnaryOperator.identity();
        }
        return base -> {
            if (base <= minSpeed) {
                return base;
            }
            double total = base;
            for (EffectRankPair pair : list) {
                total = ((ValueUpgradeEffect)pair.effect()).apply(context, pair.upgradeRank(), base, total);
            }
            return Math.max(minSpeed, Mth.floor((double)total));
        };
    }
}

