/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import liedge.limacore.client.LimaCoreClientUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXIKeyMappings;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.renderer.BubbleShieldRenderer;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import liedge.ltxindustries.client.renderer.item.LTXIItemRenderers;
import liedge.ltxindustries.item.ScrollModeSwitchItem;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.StandaloneBubbleShield;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.network.packet.ServerboundItemModeSwitchPacket;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="ltxi", value={Dist.CLIENT})
public final class LTXIClientEventHandler {
    @SubscribeEvent
    public static void fovModifyEvent(ComputeFovModifierEvent event) {
        if (event.getPlayer().isUsingItem() && event.getPlayer().getUseItem().is(LTXIItems.LINEAR_FUSION_RIFLE) && event.getNewFovModifier() > 0.1f) {
            event.setNewFovModifier(0.1f);
        }
    }

    @SubscribeEvent
    public static void playerTurnModifyEvent(CalculatePlayerTurnEvent event) {
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        if (player.isUsingItem() && player.getUseItem().is(LTXIItems.LINEAR_FUSION_RIFLE)) {
            double d0 = event.getMouseSensitivity();
            event.setMouseSensitivity(d0 * 0.275);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        BubbleShieldRenderer.SHIELD_RENDERER.tickRenderer();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer != null) {
            LTXIItemRenderers.tickValidRenderers((Player)localPlayer);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack stack = LimaCoreClientUtil.getClientMainHandItem();
        if (event.isAttack() && stack.getItem() instanceof WeaponItem) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onMouseScrollInput(InputEvent.MouseScrollingEvent event) {
        ItemStack heldItem;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !player.isSpectator() && player.input.shiftKeyDown && (heldItem = player.getMainHandItem()).getItem() instanceof ScrollModeSwitchItem) {
            int x = (int)Math.signum(event.getScrollDeltaX());
            int y = (int)Math.signum(event.getScrollDeltaY());
            int delta = x == 0 ? -y : x;
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundItemModeSwitchPacket(player.getInventory().selected, delta), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        ItemStack heldItem;
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (LTXIKeyMappings.RELOAD_KEY.consumeClick() && player != null && !player.isSpectator() && (item = (heldItem = player.getMainHandItem()).getItem()) instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            ClientWeaponControls.of((Player)player).handleReloadInput((Player)player, heldItem, weaponItem);
        }
    }

    @SubscribeEvent
    public static void onLevelStageRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            ClientLevel level = Minecraft.getInstance().level;
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            Vec3 camVec = event.getCamera().getPosition();
            float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(true);
            AbstractWeaponControls controls = (AbstractWeaponControls)Minecraft.getInstance().player.getData(LTXIAttachmentTypes.WEAPON_CONTROLS);
            for (Entity entity : level.entitiesForRendering()) {
                float shieldHealth;
                if (!entity.hasData(LTXIAttachmentTypes.BUBBLE_SHIELD) || entity == Minecraft.getInstance().player && (Minecraft.getInstance().options.getCameraType().isFirstPerson() || entity.isSpectator()) || (shieldHealth = ((StandaloneBubbleShield)entity.getData(LTXIAttachmentTypes.BUBBLE_SHIELD)).getShieldHealth()) == 0.0f) continue;
                poseStack.pushPose();
                AABB bb = entity.getBoundingBox();
                float size = entity instanceof Player ? 1.9f : (float)Math.max(Math.max(bb.getXsize(), bb.getYsize()), bb.getZsize());
                double[] pos = LTXIRenderUtil.lerpEntityCenter(entity, camVec.x, camVec.y, camVec.z, partialTick);
                poseStack.translate(pos[0], pos[1], pos[2]);
                poseStack.mulPose(Axis.YN.rotationDegrees(entity.getYRot()));
                poseStack.scale(size, size, size);
                BubbleShieldRenderer.SHIELD_RENDERER.renderBubbleShield(poseStack, bufferSource.getBuffer(LTXIRenderTypes.POSITION_COLOR_TRIANGLES), LTXIConstants.BUBBLE_SHIELD_GREEN, partialTick);
                poseStack.popPose();
            }
            LivingEntity target = controls.getFocusedTarget();
            if (target != null) {
                float lockProgress = Math.min(1.0f, controls.lerpTargetTicks(partialTick) / 20.0f);
                LTXIRenderUtil.renderLockOnIndicatorOnEntity((Entity)target, poseStack, (MultiBufferSource)bufferSource, event.getCamera(), camVec.x, camVec.y, camVec.z, partialTick, lockProgress);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderCrossHairOverlay(RenderGuiLayerEvent.Pre event) {
        ItemStack heldItem;
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR) && (heldItem = LimaCoreClientUtil.getClientMainHandItem()).getItem() instanceof WeaponItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGatherItemTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof TooltipShiftHintItem) {
            TooltipShiftHintItem item2 = (TooltipShiftHintItem)item;
            List components = event.getTooltipElements();
            if (Screen.hasShiftDown() && Minecraft.getInstance().level != null) {
                item2.appendTooltipHintComponents((Level)Minecraft.getInstance().level, stack, components::add);
            } else {
                components.add(Either.left((Object)TooltipShiftHintItem.HINT_HOVER_TOOLTIP.translate().withStyle(ChatFormatting.DARK_GRAY)));
            }
        }
    }
}

