/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client;

import java.util.Comparator;
import java.util.List;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;

public final class LTXIClientRecipes {
    public static final EnumProxy<RecipeBookCategories> FABRICATING_CATEGORY = new EnumProxy(RecipeBookCategories.class, new Object[]{() -> List.of(LTXIBlocks.FABRICATOR.toStack())});
    private static final Comparator<RecipeHolder<FabricatingRecipe>> FABRICATING_COMPARATOR = Comparator.comparing(holder -> ((FabricatingRecipe)holder.value()).getGroup()).thenComparing(RecipeHolder::id);

    private LTXIClientRecipes() {
    }

    public static Comparator<RecipeHolder<FabricatingRecipe>> comparingFabricationRecipes() {
        return FABRICATING_COMPARATOR;
    }

    public static List<RecipeHolder<FabricatingRecipe>> getUnlockedFabricatingRecipes(LocalPlayer player) {
        Level level = player.level();
        ClientRecipeBook book = player.getRecipeBook();
        return level.getRecipeManager().getAllRecipesFor((RecipeType)LTXIRecipeTypes.FABRICATING.get()).stream().filter(holder -> FabricatingRecipe.validateUnlocked((RecipeBook)book, (RecipeHolder<FabricatingRecipe>)holder, (Player)player)).sorted(LTXIClientRecipes.comparingFabricationRecipes()).toList();
    }
}

