/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public final class LTXIRenderUtil {
    public static final Direction[] ALL_SIDES = Direction.values();

    private LTXIRenderUtil() {
    }

    public static float sineAnimationCurve(float delta) {
        return Mth.sin((float)((float)Math.PI * delta));
    }

    public static float linearThresholdCurve(float delta, float threshold) {
        if (delta <= threshold) {
            return delta / threshold;
        }
        float slope = 1.0f / (1.0f - threshold);
        return 1.0f - (delta - threshold) * slope;
    }

    public static float animationCurveA(float delta) {
        return LTXIRenderUtil.linearThresholdCurve(delta, 0.2f);
    }

    public static float animationCurveB(float delta) {
        return LTXIRenderUtil.linearThresholdCurve(delta, 0.1f);
    }

    public static void renderLockOnIndicatorOnEntity(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, double xOffset, double yOffset, double zOffset, float partialTick, float lerpLockProgress) {
        poseStack.pushPose();
        VertexConsumer buffer = bufferSource.getBuffer(LTXIRenderTypes.LOCK_ON_INDICATOR);
        Matrix4f mx4 = poseStack.last().pose();
        double[] pos = LTXIRenderUtil.lerpEntityCenter(entity, xOffset, yOffset, zOffset, partialTick);
        float size = (float)entity.getBoundingBox().getSize();
        poseStack.translate(pos[0], pos[1], pos[2]);
        poseStack.mulPose(Axis.YP.rotationDegrees(-camera.getYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(camera.getXRot()));
        poseStack.scale(size, size, size);
        float f0 = (float)(Util.getMillis() % 5000L) / 5000.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.wrapDegrees((float)(f0 * 360.0f))));
        float f1 = -0.6875f - 2.0f * (1.0f - lerpLockProgress);
        LimaColor color = lerpLockProgress >= 1.0f ? LTXIConstants.LIME_GREEN : LTXIConstants.HOSTILE_ORANGE;
        LTXIRenderUtil.drawLockOnQuad(buffer, mx4, f1, 0, color);
        LTXIRenderUtil.drawLockOnQuad(buffer, mx4, f1, 120, color);
        LTXIRenderUtil.drawLockOnQuad(buffer, mx4, f1, 240, color);
        poseStack.popPose();
    }

    public static double[] lerpEntityCenter(Entity entity, double x0, double y0, double z0, float partialTick) {
        double x = Mth.lerp((double)partialTick, (double)(entity.xo - x0), (double)(entity.getX() - x0));
        double y = Mth.lerp((double)partialTick, (double)(entity.yo - y0), (double)(entity.getY() - y0)) + entity.getBoundingBox().getYsize() / 2.0;
        double z = Mth.lerp((double)partialTick, (double)(entity.zo - z0), (double)(entity.getZ() - z0));
        return new double[]{x, y, z};
    }

    public static void renderPositionColorCuboid(VertexConsumer buffer, Matrix4f mx4, float x1, float y1, float z1, float x2, float y2, float z2, LimaColor color, float alpha, Direction[] sides) {
        block8: for (Direction side : sides) {
            switch (side) {
                case UP: {
                    buffer.addVertex(mx4, x2, y2, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y2, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y2, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y2, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    continue block8;
                }
                case DOWN: {
                    buffer.addVertex(mx4, x1, y1, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y1, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y1, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y1, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    continue block8;
                }
                case WEST: {
                    buffer.addVertex(mx4, x1, y2, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y2, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y1, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y1, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    continue block8;
                }
                case EAST: {
                    buffer.addVertex(mx4, x2, y1, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y2, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y2, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y1, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    continue block8;
                }
                case SOUTH: {
                    buffer.addVertex(mx4, x1, y1, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y1, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y2, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y2, z2).setColor(color.red(), color.green(), color.blue(), alpha);
                    continue block8;
                }
                case NORTH: {
                    buffer.addVertex(mx4, x2, y2, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x2, y1, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y1, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                    buffer.addVertex(mx4, x1, y2, z1).setColor(color.red(), color.green(), color.blue(), alpha);
                }
            }
        }
    }

    private static void drawLockOnQuad(VertexConsumer buffer, Matrix4f mx4, float yOffset, int angle, LimaColor color) {
        float centerX = yOffset * Mth.cos((float)LimaCoreMath.toRad((float)angle));
        float centerY = yOffset * Mth.sin((float)LimaCoreMath.toRad((float)angle));
        float[] vtx = new float[]{-0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f};
        float cos = Mth.cos((float)(LimaCoreMath.toRad((float)angle) - 1.5707964f));
        float sin = Mth.sin((float)(LimaCoreMath.toRad((float)angle) - 1.5707964f));
        for (int i = 0; i < vtx.length; i += 2) {
            float x = vtx[i];
            float y = vtx[i + 1];
            vtx[i] = x * cos - y * sin + centerX;
            vtx[i + 1] = x * sin + y * cos + centerY;
        }
        buffer.addVertex(mx4, vtx[0], vtx[1], 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f).setUv(0.0f, 0.0f);
        buffer.addVertex(mx4, vtx[2], vtx[3], 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(mx4, vtx[4], vtx[5], 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f).setUv(1.0f, 1.0f);
        buffer.addVertex(mx4, vtx[6], vtx[7], 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f).setUv(1.0f, 0.0f);
    }
}

